/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.server.weight;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.server.weight.card.AbstractWeightCard;
import com.bokesoft.yes.mid.server.weight.card.ObjectSpaceCard;
import com.bokesoft.yes.mid.server.weight.card.SqlTimeCard;
import com.bokesoft.yes.mid.server.weight.config.SqlTimeWeightConfig;
import com.bokesoft.yes.mid.server.weight.manager.ObjectSpaceCardManager;
import com.bokesoft.yes.mid.server.weight.manager.SqlTimeCardManager;
import com.bokesoft.yes.mid.server.weight.utils.ServiceIDUtils;

public class WeightServiceCenter {
    private static final WeightServiceCenter instance = new WeightServiceCenter();

    private WeightServiceCenter() {
    }

    public void allocObjectSpaceCard(String object, String string, long l) throws Throwable {
        if (ObjectSpaceCardManager.getInstace().hasCard()) {
            return;
        }
        object = ObjectSpaceCard.newCard(l, (String)object, string);
        ObjectSpaceCardManager.getInstace().registerCard(object);
    }

    public void allocSqlTimeCard(String string, String string2) throws Throwable {
        this.allocSqlTimeCard(string, string2, null);
    }

    public void allocSqlTimeCard(String string, String string2, StringHashMap<Object> stringHashMap) throws Throwable {
        string = ServiceIDUtils.newServiceID(string, string2, stringHashMap);
        long l = SqlTimeWeightConfig.getInstance().getLimit(string);
        long l2 = SqlTimeWeightConfig.getInstance().getWarn(string);
        this.allocSqlTimeCard(string, l, l2);
    }

    public void allocSqlTimeCard(String string, long l, long l2) throws Throwable {
        if (ObjectSpaceCardManager.getInstace().hasCard()) {
            return;
        }
        SqlTimeCard sqlTimeCard = SqlTimeCard.newCard(string);
        sqlTimeCard.init(string, l, l2);
        SqlTimeCardManager.getInstace().registerCard(sqlTimeCard);
    }

    public void releaseAllCard() {
        ObjectSpaceCardManager.getInstace().release();
        SqlTimeCardManager.getInstace().release();
    }

    public SqlTimeCard getCurSqlTimeCard() {
        return (SqlTimeCard)SqlTimeCardManager.getInstace().getCard();
    }

    public void setZeroDeductionMode() throws Throwable {
        this.setZeroDeductionMode((AbstractWeightCard<?>)SqlTimeCardManager.getInstace().getCard());
        this.setZeroDeductionMode((AbstractWeightCard<?>)ObjectSpaceCardManager.getInstace().getCard());
    }

    public void setNormalDeductionMode() throws Throwable {
        this.setNormalDeductionMode((AbstractWeightCard<?>)SqlTimeCardManager.getInstace().getCard());
        this.setNormalDeductionMode((AbstractWeightCard<?>)ObjectSpaceCardManager.getInstace().getCard());
    }

    private void setZeroDeductionMode(AbstractWeightCard<?> abstractWeightCard) {
        if (abstractWeightCard == null) {
            return;
        }
        abstractWeightCard.setZeroDeductionMode();
    }

    private void setNormalDeductionMode(AbstractWeightCard<?> abstractWeightCard) {
        if (abstractWeightCard == null) {
            return;
        }
        abstractWeightCard.setNormalDeductionMode();
    }

    public static WeightServiceCenter getInstance() {
        return instance;
    }
}

