/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.server.dispatcher;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.base.DefaultMidVEFactory;
import com.bokesoft.yes.mid.base.IMidVEFactory;
import com.bokesoft.yes.mid.server.ServerData;
import com.bokesoft.yes.mid.server.ServiceRequest;
import com.bokesoft.yes.mid.server.ServiceResponse;
import com.bokesoft.yes.mid.server.dispatcher.BaseDispatcher;
import com.bokesoft.yes.mid.server.weight.WeightServiceCenter;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.server.IServiceRequest;
import com.bokesoft.yigo.mid.server.IServiceResponse;
import com.bokesoft.yigo.mid.service.ICustomServiceFilter;
import com.bokesoft.yigo.mid.service.IServiceProvider;
import com.bokesoft.yigo.mid.service.ServiceRightCheckerFactory;
import com.bokesoft.yigo.mid.service.provider.ServiceProviderFactory;
import com.bokesoft.yigo.struct.env.Env;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class LocalDispatcher
extends BaseDispatcher {
    private IServiceProvider<IServiceContext> service = null;
    private IServiceContext context = null;
    private IMidVEFactory veFactory = null;
    private List<ICustomServiceFilter> customFilters = null;

    public LocalDispatcher() {
    }

    public LocalDispatcher(IServiceProvider<IServiceContext> iServiceProvider) {
        if (iServiceProvider != null) {
            this.service = iServiceProvider.newInstance();
        }
    }

    public void setServiceContext(IServiceContext iServiceContext) {
        this.context = iServiceContext;
    }

    public void setVEFactory(IMidVEFactory iMidVEFactory) {
        this.veFactory = iMidVEFactory;
    }

    public Object process(JSONObject object) throws Throwable {
        ServiceRequest serviceRequest = new ServiceRequest();
        serviceRequest.formJSON((JSONObject)object);
        object = new ServiceResponse();
        this.processService(serviceRequest, (IServiceResponse)object);
        if (((ServiceResponse)object).hasErr()) {
            throw ((ServiceResponse)object).getException();
        }
        return ((ServiceResponse)object).getResult();
    }

    public Object process(IServiceRequest iServiceRequest) throws Throwable {
        ServiceResponse serviceResponse = new ServiceResponse();
        this.processService(iServiceRequest, serviceResponse);
        if (serviceResponse.hasErr()) {
            throw serviceResponse.getException();
        }
        return serviceResponse.getResult();
    }

    @Override
    public void processService(IServiceRequest iServiceRequest, IServiceResponse iServiceResponse) throws Throwable {
        com.bokesoft.yigo.common.struct.StringHashMap<Object> stringHashMap;
        block22: {
            Object object;
            String string;
            stringHashMap = iServiceRequest.getParameterMap();
            String string2 = TypeConvertor.toString((Object)stringHashMap.get((Object)"cmd"));
            LogSvr.getInstance().debug("---LocalDispatcher.processService()!cmd:".concat(String.valueOf(string2)));
            if (this.veFactory == null) {
                string = iServiceRequest.getHost();
                object = iServiceRequest.getPort();
                this.veFactory = new DefaultMidVEFactory(string, (String)object);
            }
            string = TypeConvertor.toString((Object)stringHashMap.get((Object)"service"));
            if (this.service == null) {
                this.service = ServiceProviderFactory.createService(string, this.veFactory);
            }
            WeightServiceCenter.getInstance().allocSqlTimeCard(string, string2, (StringHashMap<Object>)stringHashMap);
            if (this.context == null) {
                this.context = this.service.newServiceContext(this.veFactory);
            }
            this.service.prepare(this.context, string2, (StringHashMap<Object>)stringHashMap);
            object = this.context.getVE();
            if (object != null) {
                object = object.getEnv();
                this.dealEnv((Env)object, iServiceRequest, iServiceResponse);
            }
            LogSvr.getInstance().debug("LocalDispatcher call service:" + string + "cmd:" + string2);
            try {
                block25: {
                    block24: {
                        this.service.dealWithEnv(this.context, string2, new ServerData(iServiceRequest, iServiceResponse));
                        if (this.filter != null) {
                            this.filter.preProcess(this.context, (Map<String, Object>)stringHashMap);
                        }
                        LogSvr.getInstance().debug("---LocalDispatcher.processService()!serviceName:" + this.service.getServiceName());
                        LogSvr.getInstance().debug("---LocalDispatcher.processService()!serviceId:" + this.service.getServiceId(this.context, string2, (StringHashMap<Object>)stringHashMap));
                        LogSvr.getInstance().debug("---LocalDispatcher...needServiceRight():" + this.service.needServiceRight(this.context, string2));
                        string = CoreSetting.getInstance().getRightChkLevel();
                        LogSvr.getInstance().debug("---LocalDispatcher.processService()!rightChkLevel:".concat(String.valueOf(string)));
                        if (!StringUtil.isEmptyStr((String)string) && string.equals("1") && this.service.needServiceRight(this.context, string2)) {
                            ServiceRightCheckerFactory.getInstance().newChecker().serviceRightCheck(this.context, this.service, string2, (Map<String, Object>)stringHashMap);
                        }
                        this.service.preProcess(this.context, string2, (StringHashMap<Object>)stringHashMap);
                        if (this.filter == null) break block24;
                        this.filter.checkSecurity(this.context, (Map<String, Object>)stringHashMap);
                        if (!this.filter.needCheckServiceSecurity()) break block25;
                    }
                    this.service.checkSecurity(this.context, string2, (StringHashMap<Object>)stringHashMap);
                }
                object = this.customCmd != null ? this.customCmd.doCmd(this.context, (Map<String, Object>)stringHashMap) : this.service.process(this.context, string2, (StringHashMap<Object>)stringHashMap);
                object = this.wrapperResult(object);
                this.service.dealWithResult(this.context, string2, object);
                if (this.filter != null) {
                    this.filter.postProcess(this.context, (Map<String, Object>)stringHashMap);
                }
                this.service.postProcess(this.context, string2, (StringHashMap<Object>)stringHashMap);
                this.context.doMidActions();
                LocalDispatcher localDispatcher = this;
                localDispatcher.processServiceBeforeCommit(localDispatcher.context, (StringHashMap<Object>)stringHashMap);
                this.context.commit();
                LocalDispatcher localDispatcher2 = this;
                localDispatcher2.processServiceAfterCommit(localDispatcher2.context, (StringHashMap<Object>)stringHashMap);
                iServiceResponse.setResult(object);
                WeightServiceCenter.getInstance().releaseAllCard();
                if (this.filter == null) break block22;
            }
            catch (Throwable throwable) {
                block23: {
                    try {
                        LogSvr.getInstance().error("LocalDispatcher call error", throwable);
                        iServiceResponse.setException(throwable);
                        if (iServiceRequest != null) {
                            string = iServiceRequest.toJSON().toString();
                            LogSvr.getInstance().debug(string);
                        }
                        if (this.context != null) {
                            this.context.rollback();
                            LocalDispatcher localDispatcher = this;
                            localDispatcher.processServiceAfterRollback(localDispatcher.context, (StringHashMap<Object>)stringHashMap, throwable);
                        }
                        if (this.filter != null) {
                            this.filter.errorProcess(this.context, (Map<String, Object>)stringHashMap, throwable);
                        }
                        WeightServiceCenter.getInstance().releaseAllCard();
                        if (this.filter == null) break block23;
                    }
                    catch (Throwable throwable2) {
                        WeightServiceCenter.getInstance().releaseAllCard();
                        if (this.filter != null) {
                            this.filter.finalProcess(this.context, (Map<String, Object>)stringHashMap);
                        }
                        if (this.context != null) {
                            this.context.close();
                            LocalDispatcher localDispatcher = this;
                            localDispatcher.processServiceAfterClose(localDispatcher.context, (StringHashMap<Object>)stringHashMap);
                        }
                        throw throwable2;
                    }
                    this.filter.finalProcess(this.context, (Map<String, Object>)stringHashMap);
                }
                if (this.context != null) {
                    this.context.close();
                    LocalDispatcher localDispatcher = this;
                    localDispatcher.processServiceAfterClose(localDispatcher.context, (StringHashMap<Object>)stringHashMap);
                    return;
                }
            }
            this.filter.finalProcess(this.context, (Map<String, Object>)stringHashMap);
        }
        if (this.context != null) {
            this.context.close();
            LocalDispatcher localDispatcher = this;
            localDispatcher.processServiceAfterClose(localDispatcher.context, (StringHashMap<Object>)stringHashMap);
            return;
        }
    }

    private void processServiceBeforeCommit(IServiceContext iServiceContext, StringHashMap<Object> stringHashMap) throws Throwable {
        if (this.customFilters == null || this.customFilters.size() == 0) {
            return;
        }
        Iterator<ICustomServiceFilter> iterator = this.customFilters.iterator();
        while (iterator.hasNext()) {
            iterator.next().preProcess(iServiceContext, (Map<String, Object>)stringHashMap);
        }
    }

    private void processServiceAfterCommit(IServiceContext iServiceContext, StringHashMap<Object> stringHashMap) throws Throwable {
        if (this.customFilters == null || this.customFilters.size() == 0) {
            return;
        }
        Iterator<ICustomServiceFilter> iterator = this.customFilters.iterator();
        while (iterator.hasNext()) {
            iterator.next().postProcess(iServiceContext, (Map<String, Object>)stringHashMap);
        }
    }

    private void processServiceAfterRollback(IServiceContext iServiceContext, StringHashMap<Object> stringHashMap, Throwable throwable) throws Throwable {
        if (this.customFilters == null || this.customFilters.size() == 0) {
            return;
        }
        Iterator<ICustomServiceFilter> iterator = this.customFilters.iterator();
        while (iterator.hasNext()) {
            iterator.next().errorProcess(iServiceContext, (Map<String, Object>)stringHashMap, throwable);
        }
    }

    private void processServiceAfterClose(IServiceContext iServiceContext, StringHashMap<Object> stringHashMap) throws Throwable {
        if (this.customFilters == null || this.customFilters.size() == 0) {
            return;
        }
        Iterator<ICustomServiceFilter> iterator = this.customFilters.iterator();
        while (iterator.hasNext()) {
            iterator.next().finalProcess(iServiceContext, (Map<String, Object>)stringHashMap);
        }
    }

    public void setCustomFilter(List<ICustomServiceFilter> list) {
        this.customFilters = list;
    }
}

