/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.rights.cache;

import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.mid.rights.AbstractRightsVersionMgr;
import com.bokesoft.yes.mid.rights.RoleRightsVersionMgr;
import com.bokesoft.yes.mid.rights.cache.IRightsCache;
import com.bokesoft.yigo.struct.rights.CustomRights;
import com.bokesoft.yigo.struct.rights.DictRights;
import com.bokesoft.yigo.struct.rights.DictRightsCache;
import com.bokesoft.yigo.struct.rights.EntryRights;
import com.bokesoft.yigo.struct.rights.FormRights;
import com.bokesoft.yigo.struct.rights.FormRightsCache;
import com.bokesoft.yigo.struct.rights.ServiceRights;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MidRoleRightsCache
implements IRightsCache {
    private static Map<Long, DictRightsCache> dictRights = new ConcurrentHashMap<Long, DictRightsCache>();
    private static Map<Long, EntryRights> entryRights = new ConcurrentHashMap<Long, EntryRights>();
    private static Map<Long, FormRightsCache> formRights = new ConcurrentHashMap<Long, FormRightsCache>();
    private static Map<Long, CustomRights> customRights = new ConcurrentHashMap<Long, CustomRights>();
    private static Map<Long, ServiceRights> serviceRights = new ConcurrentHashMap<Long, ServiceRights>();
    private AbstractRightsVersionMgr versionMgr = new RoleRightsVersionMgr();

    private boolean checkDictRights(long l, String string) throws Throwable {
        try {
            return this.versionMgr.checkDictRights(l, string);
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error("Role DictRights check error.", throwable);
            this.clearDictRights(l, string);
            return false;
        }
    }

    @Override
    public DictRights getDictRights(long l, String string) throws Throwable {
        DictRights dictRights = null;
        if (this.checkDictRights(l, string)) {
            dictRights = this.getDictRightsCache(l).getDictRights(string);
        }
        return dictRights;
    }

    private DictRightsCache getDictRightsCache(long l) {
        DictRightsCache dictRightsCache = dictRights.get(l);
        if (dictRightsCache == null) {
            dictRightsCache = new DictRightsCache();
            dictRights.put(l, dictRightsCache);
        }
        return dictRightsCache;
    }

    private boolean checkEntryRights(long l) throws Throwable {
        try {
            return this.versionMgr.checkEntryRights(l);
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error("Role EntryRights check error.", throwable);
            this.clearEntryRights(l);
            return false;
        }
    }

    @Override
    public EntryRights getEntryRights(long l) throws Throwable {
        EntryRights entryRights = null;
        if (this.checkEntryRights(l)) {
            entryRights = MidRoleRightsCache.entryRights.get(l);
        }
        return entryRights;
    }

    private boolean checkFormRights(long l, String string) throws Throwable {
        try {
            return this.versionMgr.checkFormRights(l, string);
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error("Role FormRights check error.", throwable);
            this.clearFormRights(l, string);
            return false;
        }
    }

    @Override
    public FormRights getFormRights(long l, String string) throws Throwable {
        FormRights formRights = null;
        if (this.checkFormRights(l, string)) {
            formRights = this.getFormRightsCache(l).getFormRights(string);
        }
        return formRights;
    }

    private FormRightsCache getFormRightsCache(long l) {
        FormRightsCache formRightsCache = formRights.get(l);
        if (formRightsCache == null) {
            formRightsCache = new FormRightsCache();
            formRights.put(l, formRightsCache);
        }
        return formRightsCache;
    }

    @Override
    public void clearDictRights(long l, String string) throws Throwable {
        this.getDictRightsCache(l).remove(string);
    }

    @Override
    public void clearEntryRights(long l) throws Throwable {
        if (entryRights.containsKey(l)) {
            entryRights.remove(l);
        }
    }

    @Override
    public void clearFormRights(long l, String string) throws Throwable {
        this.getFormRightsCache(l).remove(string);
    }

    private boolean checkCustomRights(long l) throws Throwable {
        try {
            return this.versionMgr.checkCustomRights(l);
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error("Role customRights check error.", throwable);
            this.clearCustomRights(l);
            return false;
        }
    }

    @Override
    public CustomRights getCustomRights(long l) throws Throwable {
        CustomRights customRights = null;
        if (this.checkCustomRights(l)) {
            customRights = MidRoleRightsCache.customRights.get(l);
        }
        return customRights;
    }

    @Override
    public void clearCustomRights(long l) throws Throwable {
        if (customRights.containsKey(l)) {
            customRights.remove(l);
        }
    }

    @Override
    public void addEntryRights(long l, EntryRights entryRights) throws Throwable {
        MidRoleRightsCache.entryRights.put(l, entryRights);
    }

    @Override
    public void addDictRights(long l, DictRights dictRights) throws Throwable {
        String string;
        if (dictRights != null && (string = dictRights.getItemKey()) != null && !string.isEmpty()) {
            this.getDictRightsCache(l).put(string, dictRights);
        }
    }

    @Override
    public void addFormRights(long l, FormRights formRights) throws Throwable {
        String string;
        if (formRights != null && (string = formRights.getFormKey()) != null && !string.isEmpty()) {
            this.getFormRightsCache(l).put(string, formRights);
        }
    }

    @Override
    public void addCustomRights(long l, CustomRights customRights) throws Throwable {
        MidRoleRightsCache.customRights.put(l, customRights);
    }

    @Override
    public void updateCustomRights(long l) throws Throwable {
        try {
            this.versionMgr.updateCustomRights(l);
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error("Role updateCustomRights check error.", throwable);
            this.clearCustomRights(l);
        }
        this.clearCustomRights(l);
    }

    @Override
    public void updateEntryRights(long l) throws Throwable {
        try {
            this.versionMgr.updateEntryRights(l);
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error("Role updateEntryRights check error.", throwable);
            this.clearEntryRights(l);
        }
        this.clearEntryRights(l);
    }

    @Override
    public void updateDictRights(long l, String string) throws Throwable {
        try {
            this.versionMgr.updateDictRights(l, string);
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error("Role updateDictRights check error.", throwable);
            this.clearDictRights(l, string);
        }
        this.clearDictRights(l, string);
    }

    @Override
    public void updateFormRights(long l, String string) throws Throwable {
        try {
            this.versionMgr.updateFormRights(l, string);
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error("Role updateFormRights check error.", throwable);
            this.clearFormRights(l, string);
        }
        this.clearFormRights(l, string);
    }

    @Override
    public ServiceRights getSeviceRights(long l) throws Throwable {
        ServiceRights serviceRights = null;
        if (this.checkServiceRights(l)) {
            serviceRights = MidRoleRightsCache.serviceRights.get(l);
        }
        return serviceRights;
    }

    private boolean checkServiceRights(long l) throws Throwable {
        try {
            return this.versionMgr.checkServiceRights(l);
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error("Role ServiceRights check error.", throwable);
            this.clearServiceRights(l);
            return false;
        }
    }

    @Override
    public void addServiceRights(long l, ServiceRights serviceRights) throws Throwable {
        MidRoleRightsCache.serviceRights.put(l, serviceRights);
    }

    @Override
    public void clearServiceRights(long l) throws Throwable {
        if (serviceRights.containsKey(l)) {
            serviceRights.remove(l);
        }
    }

    @Override
    public void updateServiceRights(long l) throws Throwable {
        try {
            this.versionMgr.updateServiceRights(l);
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error("Role updateServiceRights check error.", throwable);
            this.clearServiceRights(l);
        }
        this.clearServiceRights(l);
    }
}

