/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.util.compext;

import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.util.compext.FieldAndMethodMap;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;

public class MethodParamTypeUtil {
    public static Object parseMethodPara(Method method, String value) {
        Class<?>[] paraTypes = method.getParameterTypes();
        Class<?> type = paraTypes[0];
        ArrayList<String> paraValue = null;
        if (type == Integer.class || type == Integer.TYPE) {
            paraValue = Integer.parseInt(value);
        } else if (type == String.class) {
            paraValue = value;
        } else if (type == BigDecimal.class) {
            paraValue = new BigDecimal(value);
        } else if (type == Double.class || type == Double.TYPE) {
            paraValue = Double.parseDouble(value);
        } else if (type == Long.class || type == Long.TYPE) {
            paraValue = Long.parseLong(value);
        } else if (type == Float.class || type == Float.TYPE) {
            paraValue = Float.valueOf(Float.parseFloat(value));
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            paraValue = Boolean.parseBoolean(value);
        } else if (type == Collection.class) {
            String[] tmpValues = value.split(";");
            int tmpLength = tmpValues.length;
            ArrayList<String> listValue = new ArrayList<String>();
            for (int j = 0; j < tmpLength; ++j) {
                listValue.add(tmpValues[j]);
            }
            paraValue = listValue;
        } else if (type == DefSize.class) {
            paraValue = DefSize.parse((String)value);
        }
        return paraValue;
    }

    public static String getAttrStrValue(MetaForm metaForm, MetaComponent metaComponent, String key) {
        if (key.equalsIgnoreCase(":FormKey")) {
            return metaForm.getKey();
        }
        if (key.equalsIgnoreCase(":ProjectKey")) {
            return metaForm.getProjectKey();
        }
        if (key.equalsIgnoreCase(":FormType")) {
            return FormType.toString((int)metaForm.getFormType());
        }
        String value = null;
        Method md = FieldAndMethodMap.getInstance().getGetMethod(metaComponent.getClass().getName(), key.toLowerCase());
        Class<?> pClass = FieldAndMethodMap.getInstance().getParseClass(metaComponent.getProperties().getClass().getName(), key.toLowerCase());
        try {
            if (md != null) {
                if (pClass != null) {
                    Object v = md.invoke((Object)metaComponent, new Object[0]);
                    Method m = pClass.getMethod("toString", Integer.TYPE);
                    if (m != null) {
                        v = m.invoke(null, v);
                        return v.toString();
                    }
                } else {
                    Object v = md.invoke((Object)metaComponent, new Object[0]);
                    if (v != null) {
                        return v.toString();
                    }
                }
            } else {
                md = FieldAndMethodMap.getInstance().getGetMethod(metaComponent.getProperties().getClass().getName(), key.toLowerCase());
                if (md != null) {
                    if (pClass != null) {
                        Object v = md.invoke((Object)metaComponent.getProperties(), new Object[0]);
                        Method m = pClass.getMethod("toString", Integer.TYPE);
                        if (m != null) {
                            v = m.invoke(null, v);
                            return v.toString();
                        }
                    } else {
                        Object v = md.invoke((Object)metaComponent.getProperties(), new Object[0]);
                        if (v != null) {
                            return v.toString();
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getAttrStrValue(MetaForm metaForm, MetaGridCell metaComponent, String key) {
        if (key.equalsIgnoreCase(":FormKey")) {
            return metaForm.getKey();
        }
        if (key.equalsIgnoreCase(":ProjectKey")) {
            return metaForm.getProjectKey();
        }
        if (key.equalsIgnoreCase(":FormType")) {
            return FormType.toString((int)metaForm.getFormType());
        }
        String value = null;
        Method md = FieldAndMethodMap.getInstance().getGetMethod(metaComponent.getClass().getName(), key.toLowerCase());
        Class<?> pClass = FieldAndMethodMap.getInstance().getParseClass(metaComponent.getProperties().getClass().getName(), key.toLowerCase());
        try {
            if (md != null) {
                if (pClass != null) {
                    Object v = md.invoke((Object)metaComponent, new Object[0]);
                    Method m = pClass.getMethod("toString", Integer.TYPE);
                    if (m != null) {
                        v = m.invoke(null, v);
                        return v.toString();
                    }
                } else {
                    Object v = md.invoke((Object)metaComponent, new Object[0]);
                    if (v != null) {
                        return v.toString();
                    }
                }
            } else {
                md = FieldAndMethodMap.getInstance().getGetMethod(metaComponent.getProperties().getClass().getName(), key.toLowerCase());
                if (md != null) {
                    if (pClass != null) {
                        Object v = md.invoke((Object)metaComponent.getProperties(), new Object[0]);
                        Method m = pClass.getMethod("toString", Integer.TYPE);
                        if (m != null) {
                            v = m.invoke(null, v);
                            return v.toString();
                        }
                    } else {
                        Object v = md.invoke((Object)metaComponent.getProperties(), new Object[0]);
                        if (v != null) {
                            return v.toString();
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getAttrStrValue(MetaForm metaForm, MetaGridRow metaComponent, String key) {
        if (key.equalsIgnoreCase(":FormKey")) {
            return metaForm.getKey();
        }
        if (key.equalsIgnoreCase(":ProjectKey")) {
            return metaForm.getProjectKey();
        }
        if (key.equalsIgnoreCase(":FormType")) {
            return FormType.toString((int)metaForm.getFormType());
        }
        String value = null;
        Method md = FieldAndMethodMap.getInstance().getGetMethod(metaComponent.getClass().getName(), key.toLowerCase());
        try {
            Object v;
            if (md != null && (v = md.invoke((Object)metaComponent, new Object[0])) != null) {
                return v.toString();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return value;
    }
}

