/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.rights;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IElementMerge;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.rights.MetaDictRightsCollection;
import com.bokesoft.yigo.meta.rights.MetaFormRightsCollection;
import java.util.LinkedList;

public class MetaRightsDefinition
extends AbstractMetaObject
implements IElementMerge<MetaRightsDefinition> {
    private MetaFormRightsCollection formRights = null;
    private MetaDictRightsCollection dictRights = null;
    private boolean allRights = false;
    public static final String TAG_NAME = "RightsDefinition";

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        if (this.formRights != null) {
            list.add(this.formRights);
        }
        if (this.dictRights != null) {
            list.add(this.dictRights);
        }
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        GenericNoKeyCollection resultMetaObject = null;
        if ("FormRightsCollection".equals(tagName)) {
            resultMetaObject = this.formRights = new MetaFormRightsCollection();
        } else if ("DictRightsCollection".equals(tagName)) {
            this.dictRights = new MetaDictRightsCollection();
            resultMetaObject = this.dictRights;
        }
        return resultMetaObject;
    }

    public boolean isAllRights() {
        return this.allRights;
    }

    public void setAllRights(boolean allRights) {
        this.allRights = allRights;
    }

    public MetaFormRightsCollection getFormRightsCollection() {
        return this.formRights;
    }

    public void setFormRightsCollection(MetaFormRightsCollection formRightsCollection) {
        this.formRights = formRightsCollection;
    }

    public MetaDictRightsCollection getDictRightsCollection() {
        return this.dictRights;
    }

    public void setDictRightsCollection(MetaDictRightsCollection dictRightsCollection) {
        this.dictRights = dictRightsCollection;
    }

    @Override
    public AbstractMetaObject clone() {
        return null;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaRightsDefinition();
    }

    public boolean hasAllFormRights(String formKey) {
        if (this.allRights) {
            return this.formRights == null ? false : this.formRights.contains(formKey);
        }
        return this.formRights == null ? true : !this.formRights.contains(formKey);
    }

    public boolean hasAllDictRights(String itemKey) {
        if (this.allRights) {
            return this.dictRights == null ? false : this.dictRights.contains(itemKey);
        }
        return this.dictRights == null ? true : !this.dictRights.contains(itemKey);
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        if (this.formRights != null) {
            this.formRights.doPostProcess(flag, callback);
        }
        if (this.dictRights != null) {
            this.dictRights.doPostProcess(flag, callback);
        }
    }

    @Override
    public MetaRightsDefinition toMerge(MetaRightsDefinition obj) {
        if (obj != null) {
            if (this.allRights != obj.allRights) {
                throw new MetaException(109, SimpleStringFormat.format((String)StringTable.getString(null, "", "SolutionNoRightsDefinedError"), (Object[])new Object[0]));
            }
            if (!this.allRights) {
                this.formRights.toMerge(obj.formRights);
                this.dictRights.toMerge(obj.dictRights);
            }
        }
        return this;
    }
}

