/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.form.component.view.layout;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormActionMap;
import com.bokesoft.yes.meta.persist.dom.form.MetaFormLoadContext;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaAction;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaFont;
import com.bokesoft.yigo.meta.form.component.MetaFormat;
import java.util.LinkedList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class MetaLayoutItem
extends KeyPairMetaObject {
    protected String key = "";
    private MetaFormat format = null;
    private Document document = null;
    private Element element = null;
    private Integer runType = null;

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setLoadTemp(Document document, Element element, int runType) {
        this.document = document;
        this.element = element;
        this.runType = runType;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        if (this.format != null) {
            list.add(this.format);
        }
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        if (tagName.equals("Format")) {
            this.format = new MetaFormat();
            return this.format;
        }
        return null;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaLayoutItem newObject = (MetaLayoutItem)this.newInstance();
        newObject.setKey(this.key);
        return newObject;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        MetaComponent metaComp = MetaFormLoadContext.getComponentByKey(this.key);
        if (metaComp != null) {
            IMetaAction<AbstractMetaObject> action;
            if (this.format != null) {
                MetaLayoutItem.loadFormat(this.format, metaComp);
            }
            if (this.document != null && this.element != null && this.runType != null && (action = MetaFormActionMap.getInstance().getAction(metaComp.getTagName())) instanceof BaseDomAction) {
                ((BaseDomAction)action).load(this.document, this.element, metaComp, this.runType);
            }
        }
        this.format = null;
        this.document = null;
        this.element = null;
        this.runType = null;
    }

    public static void loadFormat(MetaFormat format, MetaComponent metaComp) {
        MetaFont font;
        String highlightBackColor;
        String backColor;
        String foreColor;
        int vAlign;
        MetaFormat compFormat = metaComp.ensureFormat();
        int hAlign = format.getHAlign();
        if (hAlign >= 0) {
            compFormat.setHAlign(hAlign);
        }
        if ((vAlign = format.getVAlign()) >= 0) {
            compFormat.setVAlign(vAlign);
        }
        if ((foreColor = format.getForeColor()) != null && !foreColor.isEmpty()) {
            compFormat.setForeColor(foreColor);
        }
        if ((backColor = format.getBackColor()) != null && !backColor.isEmpty()) {
            compFormat.setBackColor(backColor);
        }
        if ((highlightBackColor = format.getHighlightBackColor()) != null && !highlightBackColor.isEmpty()) {
            compFormat.setHighlightBackColor(highlightBackColor);
        }
        if ((font = format.getFont()) != null) {
            Boolean italic;
            Boolean bold;
            int size;
            String name;
            MetaFont compFont = compFormat.getFont();
            if (compFont == null) {
                compFont = new MetaFont();
                compFormat.setFont(compFont);
            }
            if ((name = font.getName()) != null && !name.isEmpty()) {
                compFont.setName(name);
            }
            if ((size = font.getSize()) >= 0) {
                compFont.setSize(size);
            }
            if ((bold = font.getBold()) != null) {
                compFont.setBold(bold);
            }
            if ((italic = font.getItalic()) != null) {
                compFont.setItalic(italic);
            }
        }
    }
}

