/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.form.component.panel.gridpanel;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaExtraLayout;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaGridLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSpan;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public class MetaGridLayoutPanel
extends MetaPanel {
    private MetaRowDefCollection rowDefCollection = null;
    private MetaExtraLayout metaExtraLayout = null;
    private MetaColumnDefCollection columnDefCollection = null;
    private String oddColumnColor = "";
    private Boolean forceLayout = true;
    public static final String TAG_NAME = "GridLayoutPanel";

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        super.getChildMetaObjects(list);
        this.addAll(list, new Object[]{this.rowDefCollection, this.columnDefCollection, this.metaExtraLayout});
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public int getControlType() {
        return 2;
    }

    public String getOddColumnColor() {
        return this.oddColumnColor;
    }

    public void setOddColumnColor(String oddColumnColor) {
        this.oddColumnColor = oddColumnColor;
    }

    public MetaExtraLayout getMetaExtraLayout() {
        return this.metaExtraLayout;
    }

    public void setMetaExtraLayout(MetaExtraLayout metaExtraLayout) {
        this.metaExtraLayout = metaExtraLayout;
    }

    public void setRowDefCollection(MetaRowDefCollection rowDefCollection) {
        this.rowDefCollection = rowDefCollection;
    }

    public MetaRowDefCollection getMetaRowDefCollection() {
        return this.rowDefCollection;
    }

    public void setColumnDefCollection(MetaColumnDefCollection columnDefCollection) {
        this.columnDefCollection = columnDefCollection;
    }

    public MetaColumnDefCollection getMetaColumnDefCollection() {
        return this.columnDefCollection;
    }

    public void setForceLayout(Boolean forceLayout) {
        this.forceLayout = forceLayout;
    }

    public Boolean isForceLayout() {
        return this.forceLayout;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject metaObject = null;
        if ("RowDefCollection".equalsIgnoreCase(tagName)) {
            metaObject = this.rowDefCollection = new MetaRowDefCollection();
        } else if ("ColumnDefCollection".equalsIgnoreCase(tagName)) {
            this.columnDefCollection = new MetaColumnDefCollection();
            metaObject = this.columnDefCollection;
        } else if ("ExtraLayout".equalsIgnoreCase(tagName)) {
            this.metaExtraLayout = new MetaExtraLayout();
            metaObject = this.metaExtraLayout;
        } else {
            metaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
        }
        return metaObject;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaGridLayoutPanel newObject = (MetaGridLayoutPanel)super.clone();
        newObject.setRowDefCollection(this.rowDefCollection == null ? null : (MetaRowDefCollection)this.rowDefCollection.clone());
        newObject.setColumnDefCollection(this.columnDefCollection == null ? null : (MetaColumnDefCollection)this.columnDefCollection.clone());
        newObject.setMetaExtraLayout(this.metaExtraLayout == null ? null : (MetaExtraLayout)this.metaExtraLayout.clone());
        newObject.setOddColumnColor(this.oddColumnColor);
        newObject.setForceLayout(this.forceLayout);
        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaGridLayoutPanel();
    }

    public MetaGridLayout newLayout() {
        MetaGridLayout layout = new MetaGridLayout();
        layout.setKey(this.key);
        layout.setRowDefCollection(this.rowDefCollection);
        layout.setColumnDefCollection(this.columnDefCollection);
        Iterator it = this.componentArray.iterator();
        MetaComponent metaComponent = null;
        while (it.hasNext()) {
            metaComponent = (MetaComponent)it.next();
            MetaLayoutSpan item = new MetaLayoutSpan();
            item.setKey(metaComponent.getKey());
            item.setX(metaComponent.getX());
            item.setY(metaComponent.getY());
            item.setXSpan(metaComponent.getXSpan());
            item.setYSpan(metaComponent.getYSpan());
            item.setHeight(metaComponent.getHeight());
            layout.add((KeyPairMetaObject)item);
        }
        return layout;
    }

    @Override
    public AbstractMetaObject getProperties() {
        return null;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        for (MetaComponent metaComponent : this.componentArray) {
            if (metaComponent.getY() + metaComponent.getYSpan() > this.rowDefCollection.size()) {
                throw new MetaException(121, SimpleStringFormat.format((String)StringTable.getString(null, "", "RowDefinitionOutRange"), (Object[])new Object[]{this.getKey(), metaComponent.getKey()}));
            }
            if (metaComponent.getX() + metaComponent.getXSpan() <= this.columnDefCollection.size()) continue;
            throw new MetaException(122, SimpleStringFormat.format((String)StringTable.getString(null, "", "ColumnDefinitionOutRange"), (Object[])new Object[]{this.getKey(), metaComponent.getKey()}));
        }
        this.componentArray.sort(new Comparator<MetaComponent>(){

            @Override
            public int compare(MetaComponent m1, MetaComponent m2) {
                if (m1.getY() < m2.getY()) {
                    return -1;
                }
                if (m1.getY() > m2.getY()) {
                    return 1;
                }
                return m1.getX() - m2.getX();
            }
        });
        super.doPostProcess(flag, callback);
    }

    @Override
    public void merge(MetaComponent meta) {
        super.merge(meta);
        MetaGridLayoutPanel metaPanel = (MetaGridLayoutPanel)meta;
        if (this.oddColumnColor == null) {
            this.oddColumnColor = metaPanel.getOddColumnColor();
        }
        if (this.forceLayout == null) {
            this.forceLayout = metaPanel.isForceLayout();
        }
        if (this.metaExtraLayout == null) {
            this.metaExtraLayout = metaPanel.getMetaExtraLayout();
        } else {
            this.metaExtraLayout.merge(metaPanel.getMetaExtraLayout());
        }
        MetaRowDefCollection rowDefCollection2 = metaPanel.getMetaRowDefCollection();
        int rowDefSize = this.rowDefCollection.size();
        int rowDefSize2 = rowDefCollection2.size();
        for (int i = rowDefSize; i < rowDefSize2; ++i) {
            this.rowDefCollection.add(rowDefCollection2.get(i));
        }
        MetaColumnDefCollection columnDefCollection2 = metaPanel.getMetaColumnDefCollection();
        int columnDefSize = this.columnDefCollection.size();
        int columnDefSize2 = columnDefCollection2.size();
        for (int i = columnDefSize; i < columnDefSize2; ++i) {
            this.columnDefCollection.add(columnDefCollection2.get(i));
        }
    }
}

