/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.form;

import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaNavigationBar;
import com.bokesoft.yigo.meta.form.anim.MetaAnimCollection;
import com.bokesoft.yigo.meta.form.anim.MetaAnimItem;
import com.bokesoft.yigo.meta.mobiledef.MetaMobileDef;
import com.bokesoft.yigo.meta.mobiledef.MetaWatermark;

public class MetaFormMergeHandler {
    private static MetaFormMergeHandler INSTANCE = null;
    private IMetaFactory metaFactory = null;
    private MetaForm metaForm = null;

    public static MetaFormMergeHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MetaFormMergeHandler();
        }
        return INSTANCE;
    }

    public void setMetaForm(MetaForm metaForm) {
        this.metaForm = metaForm;
    }

    public void setMetaFactory(IMetaFactory metaFactory) {
        this.metaFactory = metaFactory;
    }

    public MetaMobileDef getMobileDefInProject() {
        if (this.metaForm == null) {
            return null;
        }
        MetaMobileDef projectMobileDef = null;
        try {
            projectMobileDef = this.metaFactory.getMobileDef(this.metaForm.getProjectKey());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return projectMobileDef;
    }

    public MetaMobileDef getMobileDefInSolution() {
        if (this.metaForm == null) {
            return null;
        }
        MetaMobileDef solutionMobileDef = null;
        try {
            solutionMobileDef = this.metaFactory.getMobileDef(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return solutionMobileDef;
    }

    public void preMergeMetaObject() {
        MetaMobileDef projectMobileDef = this.getMobileDefInProject();
        MetaMobileDef solutionMobileDef = this.getMobileDefInSolution();
        if (this.metaForm.getMetaNavigation() == null) {
            Boolean projectHasNavigationBar = projectMobileDef != null && projectMobileDef.getNavigationBar() != null;
            Boolean solutionHasNavigationBar = solutionMobileDef != null && solutionMobileDef.getNavigationBar() != null;
            if (projectHasNavigationBar.booleanValue() || solutionHasNavigationBar.booleanValue()) {
                this.metaForm.setNavigation(new MetaNavigationBar());
            }
        }
    }

    public void mergeCommonPropertiesWithMobileDef() {
        MetaAnimItem item;
        int i;
        MetaAnimCollection solutionAnimCollection;
        MetaMobileDef projectMobileDef = this.getMobileDefInProject();
        MetaMobileDef solutionMobileDef = this.getMobileDefInSolution();
        String hasNavigationBar = this.metaForm.isHasNavigationBar();
        if (hasNavigationBar.isEmpty() && projectMobileDef != null) {
            hasNavigationBar = projectMobileDef.getHasNavigationBar();
        }
        if (hasNavigationBar.isEmpty() && solutionMobileDef != null) {
            hasNavigationBar = solutionMobileDef.getHasNavigationBar();
        }
        this.metaForm.setHasNavigationBar(hasNavigationBar);
        Boolean disableKeyboard = this.metaForm.isDisableKeyboard();
        if (disableKeyboard == null && projectMobileDef != null) {
            disableKeyboard = projectMobileDef.isDisableKeyboard();
        }
        if (disableKeyboard == null && solutionMobileDef != null) {
            disableKeyboard = solutionMobileDef.isDisableKeyboard();
        }
        this.metaForm.setDisableKeyboard(disableKeyboard);
        MetaAnimCollection animCollection = this.metaForm.getAnimCollection();
        MetaAnimCollection projectAnimCollection = projectMobileDef == null ? null : projectMobileDef.getAnimCollection();
        MetaAnimCollection metaAnimCollection = solutionAnimCollection = solutionMobileDef == null ? null : solutionMobileDef.getAnimCollection();
        if (animCollection == null) {
            animCollection = new MetaAnimCollection();
        }
        if (projectAnimCollection != null && projectAnimCollection.size() > 0) {
            for (i = 0; i < projectAnimCollection.size(); ++i) {
                item = (MetaAnimItem)projectAnimCollection.get(i);
                animCollection.add(item);
            }
        }
        if (solutionAnimCollection != null && solutionAnimCollection.size() > 0) {
            for (i = 0; i < solutionAnimCollection.size(); ++i) {
                item = (MetaAnimItem)solutionAnimCollection.get(i);
                animCollection.add(item);
            }
        }
        this.metaForm.setAnimCollection(animCollection.size() == 0 ? null : animCollection);
        int fullScreenType = this.metaForm.getFullScreenType();
        if (fullScreenType == -1) {
            if (projectMobileDef != null) {
                fullScreenType = projectMobileDef.getFullscreenType();
            }
            if (fullScreenType == -1 && solutionMobileDef != null) {
                fullScreenType = solutionMobileDef.getFullscreenType();
            }
        }
        this.metaForm.setFullScreenType(fullScreenType);
        String statusBarColor = this.metaForm.getStatusBarColor();
        if (statusBarColor == null) {
            if (projectMobileDef != null) {
                statusBarColor = projectMobileDef.getStatusBarColor();
            }
            if (statusBarColor == null && solutionMobileDef != null) {
                statusBarColor = solutionMobileDef.getStatusBarColor();
            }
        }
        this.metaForm.setStatusBarColor(statusBarColor);
        MetaWatermark watermark = this.metaForm.getWatermark();
        if (watermark == null) {
            if (projectMobileDef != null) {
                watermark = projectMobileDef.getWatermark();
            }
            if (watermark == null && solutionMobileDef != null) {
                watermark = solutionMobileDef.getWatermark();
            }
        }
        this.metaForm.setWatermark(watermark);
    }
}

