/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.factory.workflow;

import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.factory.workflow.ProcessSourceMapContainer;
import com.bokesoft.yigo.meta.factory.workflow.source.IProcessSource;
import com.bokesoft.yigo.meta.factory.workflow.source.ProcessDefinationDB;
import com.bokesoft.yigo.meta.factory.workflow.source.ProcessDefinationDirectory;
import java.util.HashMap;

public class ProcessSourceFactory {
    private HashMap<String, IMetaResolver> projectResolverMap = null;
    private ProcessDefinitionProfile profile = null;

    public ProcessSourceFactory(HashMap<String, IMetaResolver> projectResolverMap, ProcessDefinitionProfile profile) {
        this.projectResolverMap = projectResolverMap;
        this.profile = profile;
    }

    public IProcessSource getProcessSource() {
        String sourceType = this.profile.getSourceType();
        String uniqueKey = this.profile.getKey() + "_V" + this.profile.getVersion();
        IProcessSource processSource = ProcessSourceMapContainer.getInstance().getProcessSourceMap().get(uniqueKey);
        if (processSource != null) {
            return processSource;
        }
        if ("DB".equalsIgnoreCase(sourceType)) {
            processSource = new ProcessDefinationDB(this.profile.getJsonUnserializer());
        } else if ("Directory".equalsIgnoreCase(sourceType)) {
            processSource = new ProcessDefinationDirectory(this.projectResolverMap, this.profile);
        }
        return processSource;
    }
}

