/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.factory;

import com.bokesoft.yigo.meta.base.IMetaResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.List;

public class MetaResourceResolver
implements IMetaResolver {
    private String parentPath = null;

    public MetaResourceResolver(String parentPath) {
        this.parentPath = parentPath;
    }

    @Override
    public boolean isListAbsolutePath() {
        return false;
    }

    @Override
    public InputStream read(String resource, int type) throws Exception {
        File f = new File(this.parentPath + File.separatorChar + resource);
        if (f.isDirectory() || !f.exists()) {
            return null;
        }
        return new FileInputStream(f);
    }

    @Override
    public URI getURI(String resource, int type) throws Exception {
        File f = new File(this.parentPath + File.separatorChar + resource);
        if (f.isDirectory() || !f.exists()) {
            return null;
        }
        return f.toURI();
    }

    @Override
    public boolean write(String resource, byte[] data) throws Exception {
        File f = new File(this.parentPath + File.separatorChar + resource);
        if (!f.exists()) {
            f.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(f);
        out.write(data);
        out.close();
        return true;
    }

    @Override
    public int listResource(String resource, String flag, List<String> resources, List<String> names, List<Boolean> flags) throws Exception {
        File f = new File(this.parentPath + File.separatorChar + resource);
        File[] files = f.listFiles();
        if (files != null) {
            int length = files.length;
            File childFile = null;
            for (int i = 0; i < length; ++i) {
                childFile = files[i];
                resources.add(childFile.getName());
                names.add(childFile.getName());
                if (childFile.isDirectory()) {
                    flags.add(true);
                    continue;
                }
                flags.add(false);
            }
        }
        return resources.size();
    }

    @Override
    public String getPath(String resource) {
        return this.parentPath + File.separatorChar + resource;
    }

    @Override
    public char getSeparator() {
        return File.separatorChar;
    }
}

