/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.factory;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.strings.MetaStringTable;
import com.bokesoft.yigo.meta.strings.MetaStringTableProfile;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class GlobalI18N {
    private StringHashMap<MetaStringTable> formStringsMap = StringHashMap.newInstance();
    private StringHashMap<List<MetaStringTableProfile>> formProfileMap = StringHashMap.newInstance();
    private StringHashMap<MetaStringTable> processStringsMap = StringHashMap.newInstance();
    private StringHashMap<List<MetaStringTableProfile>> processProfileMap = StringHashMap.newInstance();
    private StringHashMap<MetaStringTable> dataObjectStringsMap = StringHashMap.newInstance();
    private StringHashMap<List<MetaStringTableProfile>> dataObjectProfileMap = StringHashMap.newInstance();
    private List<MetaStringTableProfile> solutionMultiLangList = new ArrayList<MetaStringTableProfile>();
    private MetaStringTable strings = null;
    private List<MetaStringTableProfile> solutionMapMultiLangList = new ArrayList<MetaStringTableProfile>();
    private MetaStringTable mapStrings = null;
    private List<MetaStringTableProfile> solutionMigrationMultiLangList = new ArrayList<MetaStringTableProfile>();
    private MetaStringTable migrationStrings = null;

    public void addSolutionProfile(MetaStringTableProfile profile) {
        this.solutionMultiLangList.add(profile);
    }

    public void addSolutionMapProfile(MetaStringTableProfile profile) {
        this.solutionMapMultiLangList.add(profile);
    }

    public void addSolutionMigrationProfile(MetaStringTableProfile profile) {
        this.solutionMigrationMultiLangList.add(profile);
    }

    public void clearSolutionI18N() {
        this.solutionMultiLangList.clear();
        this.solutionMapMultiLangList.clear();
        this.solutionMigrationMultiLangList.clear();
        this.strings = null;
        this.mapStrings = null;
        this.migrationStrings = null;
    }

    public void loadAll() throws Throwable {
        this.getSolutionStrings();
        this.getSolutionMapStrings();
        this.getSolutionMigrationStrings();
        this.loadAllBPMString();
        this.loadAllDataObjectStrings();
    }

    public MetaStringTable getSolutionStrings() throws Throwable {
        if (this.strings == null) {
            this.strings = this.__load__(this.solutionMultiLangList, new MetaStringTable());
        }
        return this.strings;
    }

    public void setSolutionStrings(MetaStringTable strings) throws Throwable {
        this.strings = strings;
    }

    public MetaStringTable getSolutionStrings(String lang) throws Throwable {
        if (this.strings == null) {
            this.strings = this.__load__(this.solutionMultiLangList, new MetaStringTable(), lang);
        }
        return this.strings;
    }

    public MetaStringTable getSolutionMapStrings() throws Throwable {
        if (this.mapStrings == null) {
            this.mapStrings = this.__load__(this.solutionMultiLangList, new MetaStringTable());
        }
        return this.mapStrings;
    }

    public MetaStringTable getSolutionMigrationStrings() throws Throwable {
        if (this.migrationStrings == null) {
            this.migrationStrings = this.__load__(this.solutionMultiLangList, new MetaStringTable());
        }
        return this.migrationStrings;
    }

    public void addFormProfile(String formKey, MetaStringTableProfile profile) {
        ArrayList<MetaStringTableProfile> list = (ArrayList<MetaStringTableProfile>)this.formProfileMap.get((Object)formKey);
        if (list == null) {
            list = new ArrayList<MetaStringTableProfile>();
            this.formProfileMap.put((Object)formKey, list);
        }
        list.add(profile);
    }

    public MetaStringTable getFormStrings(String formKey) throws Throwable {
        MetaStringTable strings = (MetaStringTable)this.formStringsMap.get((Object)formKey);
        if (strings == null) {
            strings = this.loadFormStrings(formKey);
        }
        return strings;
    }

    public void addProcessProfile(String processKey, MetaStringTableProfile profile) {
        ArrayList<MetaStringTableProfile> list = (ArrayList<MetaStringTableProfile>)this.processProfileMap.get((Object)processKey);
        if (list == null) {
            list = new ArrayList<MetaStringTableProfile>();
            this.processProfileMap.put((Object)processKey, list);
        }
        list.add(profile);
    }

    public MetaStringTable getProcessStrings(String processKey) throws Throwable {
        MetaStringTable strings = (MetaStringTable)this.processStringsMap.get((Object)processKey);
        if (strings == null) {
            strings = this.loadProcessStrings(processKey);
        }
        return strings;
    }

    public void addDataObjectProfile(String dataObjectKey, MetaStringTableProfile profile) {
        ArrayList<MetaStringTableProfile> list = (ArrayList<MetaStringTableProfile>)this.dataObjectProfileMap.get((Object)dataObjectKey);
        if (list == null) {
            list = new ArrayList<MetaStringTableProfile>();
            this.dataObjectProfileMap.put((Object)dataObjectKey, list);
        }
        list.add(profile);
    }

    public MetaStringTable getDataObjectStrings(String dataObjectKey) throws Throwable {
        MetaStringTable strings = (MetaStringTable)this.dataObjectStringsMap.get((Object)dataObjectKey);
        if (strings == null) {
            strings = this.loadDataObjectStrings(dataObjectKey);
        }
        return strings;
    }

    public void loadAllBPMString() throws Throwable {
        this.processStringsMap.clear();
        Set keySet = this.processProfileMap.keySet();
        for (String key : keySet) {
            List list = (List)this.processProfileMap.get((Object)key);
            MetaStringTable strings = this.__load__(list, new MetaStringTable());
            this.processStringsMap.put((Object)key, (Object)strings);
        }
    }

    public void loadAllDataObjectStrings() throws Throwable {
        this.dataObjectStringsMap.clear();
        Set keySet = this.dataObjectProfileMap.keySet();
        for (String key : keySet) {
            List list = (List)this.dataObjectProfileMap.get((Object)key);
            MetaStringTable strings = this.__load__(list, new MetaStringTable());
            this.dataObjectStringsMap.put((Object)key, (Object)strings);
        }
    }

    private MetaStringTable loadFormStrings(String formKey) throws Throwable {
        MetaStringTable strings = new MetaStringTable();
        List list = (List)this.formProfileMap.get((Object)formKey);
        if (list != null) {
            this.formStringsMap.put((Object)formKey, (Object)this.__load__(list, strings));
        }
        return strings;
    }

    private MetaStringTable loadProcessStrings(String processKey) throws Throwable {
        MetaStringTable strings = new MetaStringTable();
        List list = (List)this.processProfileMap.get((Object)processKey);
        if (list != null) {
            this.processStringsMap.put((Object)processKey, (Object)this.__load__(list, strings));
        }
        return strings;
    }

    private MetaStringTable loadDataObjectStrings(String dataObjectKey) throws Throwable {
        MetaStringTable strings = new MetaStringTable();
        List list = (List)this.dataObjectProfileMap.get((Object)dataObjectKey);
        if (list != null) {
            this.dataObjectStringsMap.put((Object)dataObjectKey, (Object)this.__load__(list, strings));
        }
        return strings;
    }

    private MetaStringTable __load__(List<MetaStringTableProfile> list, MetaStringTable strings) throws Throwable {
        for (MetaStringTableProfile profile : list) {
            String filePath = profile.getFilePath();
            String lang = profile.getLang();
            IMetaResolver resolver = profile.getResolver();
            InputStream in = resolver.read(filePath, 0);
            strings.load(lang, in);
            in.close();
        }
        return strings;
    }

    private MetaStringTable __load__(List<MetaStringTableProfile> list, MetaStringTable strings, String key) throws Throwable {
        for (MetaStringTableProfile profile : list) {
            String filePath = profile.getFilePath();
            String lang = profile.getLang();
            if (!lang.equals(key)) continue;
            IMetaResolver resolver = profile.getResolver();
            InputStream in = resolver.read(filePath, 0);
            strings.load(lang, in);
            in.close();
        }
        return strings;
    }
}

