/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.factory;

import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import com.bokesoft.yigo.meta.factory.MetaResourceResolver;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class DefaultMetaResolverFactory
implements IMetaResolverFactory {
    private String solutionPath = "";
    private Map<String, Object> paras = null;

    public DefaultMetaResolverFactory(String solutionPath) {
        this.solutionPath = solutionPath;
    }

    public DefaultMetaResolverFactory() {
    }

    @Override
    public String getSolutionPath() {
        return this.solutionPath;
    }

    @Override
    public IMetaResolver newMetaResolver(String prefix) {
        return new MetaResourceResolver(this.solutionPath + prefix);
    }

    @Override
    public IMetaResolver newFileMetaResolver(String prefix) {
        String path = "";
        if (prefix.startsWith("/") || prefix.indexOf(":") > 0) {
            path = prefix;
        } else {
            File file = new File(this.solutionPath, prefix);
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new MetaResourceResolver(path);
    }

    @Override
    public char getSeparator() {
        return File.separatorChar;
    }

    @Override
    public void initParas(Map<String, Object> paras) {
        this.paras = paras;
        if (paras != null && paras.containsKey("SOLUTIONPATH")) {
            this.solutionPath = TypeConvertor.toString((Object)paras.get("SOLUTIONPATH"));
        }
    }
}

