/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.dataobject;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class MetaTableCollection
extends GenericKeyCollection<MetaTable> {
    public static final String TAG_NAME = "TableCollection";
    private ArrayList<String> tableLogicList = new ArrayList();

    public int indexOf(MetaTable table) {
        int index = -1;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ++index;
            MetaTable metaTable = (MetaTable)it.next();
            if (!table.getKey().equals(metaTable.getKey())) continue;
            return index;
        }
        return -1;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        MetaTable resultMetaObject = null;
        if (tagName.equalsIgnoreCase("Table")) {
            resultMetaObject = new MetaTable();
            resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
            this.add(resultMetaObject);
        }
        return resultMetaObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaTableCollection();
    }

    public ArrayList<String> getTableLogicList() {
        return this.tableLogicList;
    }

    public void setTableLogicList(ArrayList<String> tableLogicList) {
        this.tableLogicList = tableLogicList;
    }

    public void doPostProcess(String mainTableKey) throws MetaException {
        if (mainTableKey != null) {
            this.tableLogicList.add(mainTableKey);
        } else {
            this.tableLogicList.add("");
        }
        ArrayList<Object> checkList = new ArrayList<Object>();
        for (Object table : this) {
            if (((MetaTable)table).getTableMode() == 0) {
                ((MetaTable)table).setLevelID(1);
                if (((MetaTable)table).getKey().equalsIgnoreCase(mainTableKey)) continue;
                this.tableLogicList.add(1, ((MetaTable)table).getKey());
                continue;
            }
            String string = ((MetaTable)table).getParentKey();
            if (string != null && string.length() > 0) {
                checkList.add(table);
                continue;
            }
            ((MetaTable)table).setLevelID(2);
            this.tableLogicList.add(((MetaTable)table).getKey());
        }
        ArrayList<MetaTable> tempRemoveList = new ArrayList<MetaTable>();
        while (checkList.size() > 0) {
            for (MetaTable metaTable : checkList) {
                String string = metaTable.getParentKey();
                MetaTable parentTable = (MetaTable)this.get(string);
                if (parentTable == null) {
                    throw new MetaException(15, SimpleStringFormat.format((String)StringTable.getString(null, "", "UnlocateDataLevel"), (Object[])new Object[]{metaTable.getKey()}));
                }
                if (parentTable.getLevelID() <= 0) continue;
                metaTable.setLevelID(parentTable.getLevelID() + 1);
                this.tableLogicList.add(metaTable.getKey());
                tempRemoveList.add(metaTable);
            }
            if (tempRemoveList.size() == 0) {
                String errStr = "";
                for (MetaTable metaTable : checkList) {
                    errStr = errStr + "\"" + metaTable.getKey() + "\"";
                }
                throw new MetaException(15, SimpleStringFormat.format((String)StringTable.getString(null, "", "UnlocateDataLevel"), (Object[])new Object[]{errStr}));
            }
            checkList.removeAll(tempRemoveList);
            tempRemoveList.clear();
        }
    }
}

