/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.datamap.calculate;

import com.bokesoft.yes.common.util.ConstUtil;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollectionWithKey;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.datamap.calculate.MetaMapEdge;
import com.bokesoft.yigo.meta.datamap.calculate.RefFieldMap;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceField;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceTable;
import com.bokesoft.yigo.meta.datamap.target.MetaFeedback;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetField;
import com.bokesoft.yigo.meta.datamap.target.MetaTargetTable;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class MetaMapParas {
    private MetaMap meta;
    private String key;
    private MetaSourceField focusField;
    private Integer tgtFocusFieldDataType;
    private MetaSourceField mapKeyField;
    private String primarySourceTableKey;
    private String primaryTgtTableKey;
    private MetaMapEdge primaryMapEdge;
    private HashMap<String, RefFieldMap> refFieldMap = new HashMap();
    private ArrayList<String> sourceHeadTableList = new ArrayList();
    private ArrayList<String> targetHeadTableList = new ArrayList();
    private boolean needMapValue = false;
    private boolean isNegtive = false;

    public MetaMapParas(MetaMap meta, IMetaFactory factory) throws Throwable {
        AbstractMetaObject field;
        Iterator iterator;
        boolean bl;
        this.meta = meta;
        MetaMapParas.logicCheck(meta);
        this.key = meta.getKey();
        MetaDataObject srcDataObject = factory.getDataObject(meta.getSrcDataObjectKey());
        MetaDataObject tgtDataObject = factory.getDataObject(meta.getTgtDataObjectKey());
        if (srcDataObject == null) {
            throw new MetaException(25, SimpleStringFormat.format((String)StringTable.getString(null, "", "NoDataObjectDefined"), (Object[])new Object[]{meta.getSrcDataObjectKey()}));
        }
        if (tgtDataObject == null) {
            throw new MetaException(25, SimpleStringFormat.format((String)StringTable.getString(null, "", "NoDataObjectDefined"), (Object[])new Object[]{meta.getTgtDataObjectKey()}));
        }
        for (Object table : meta.getSourceTableCollection()) {
            if (!((MetaSourceTable)table).isPrimary()) continue;
            this.primarySourceTableKey = ((MetaSourceTable)table).getKey();
            this.primaryTgtTableKey = ((MetaSourceTable)table).getTargetTableKey();
            Iterator iterator2 = ((GenericNoKeyCollectionWithKey)table).iterator();
            while (iterator2.hasNext()) {
                MetaSourceField field2 = (MetaSourceField)iterator2.next();
                if (field2.getEdgeType() == 1) {
                    this.focusField = field2;
                    this.isNegtive = this.focusField.isNegtive();
                    this.tgtFocusFieldDataType = ((MetaColumn)tgtDataObject.getMetaTable(this.primaryTgtTableKey).get(field2.getTargetFieldKey())).getDataType();
                }
                if (field2.getEdgeType() != 3) continue;
                this.mapKeyField = field2;
                Integer dataType = 1002;
                if (field2.getType() == 2) {
                    field2.setConstValue(ConstUtil.getValue((String)field2.getDefinition(), (int)dataType));
                    continue;
                }
                if (field2.getType() == 0) {
                    Integer srcDataType = ((MetaColumn)srcDataObject.getMetaTable(((MetaSourceTable)table).getKey()).get(field2.getDefinition())).getDataType();
                    if (srcDataType.equals(dataType)) continue;
                    field2.setNeedTypeConvert(true);
                    field2.setTargetFieldDataType(dataType);
                    continue;
                }
                field2.setNeedTypeConvert(true);
                field2.setTargetFieldDataType(dataType);
            }
        }
        ArrayList<MetaSourceTable> reomveEmptyTables = new ArrayList<MetaSourceTable>();
        for (MetaSourceTable metaSourceTable : meta.getSourceTableCollection()) {
            RefFieldMap map = this.refFieldMap.get(metaSourceTable.getKey());
            ArrayList<MetaSourceField> reomveEmptyColumns = new ArrayList<MetaSourceField>();
            for (MetaSourceField sourceField : metaSourceTable) {
                if (sourceField.getRefFieldKey() != null && sourceField.getRefFieldKey().length() > 0) {
                    if (map == null) {
                        map = new RefFieldMap(metaSourceTable.getKey());
                        this.refFieldMap.put(metaSourceTable.getKey(), map);
                    }
                    map.add(sourceField.getDefinition(), sourceField.getRefFieldKey());
                }
                if (sourceField.getEdgeType() < 0) {
                    reomveEmptyColumns.add(sourceField);
                    continue;
                }
                if (sourceField.getTargetTableKey() == null || sourceField.getTargetTableKey().length() == 0) {
                    sourceField.setTargetTableKey(metaSourceTable.getTargetTableKey());
                }
                if (sourceField.getTargetTableKey() == null || sourceField.getTargetTableKey().length() == 0 || sourceField.getTargetFieldKey() == null || sourceField.getTargetFieldKey().length() == 0) {
                    reomveEmptyColumns.add(sourceField);
                    continue;
                }
                MetaTable metaTable = tgtDataObject.getMetaTable(sourceField.getTargetTableKey());
                if (metaTable == null) {
                    throw new MetaException(34, SimpleStringFormat.format((String)StringTable.getString(null, "", "MapTargetTableMiss"), (Object[])new Object[]{sourceField.getTargetFieldKey(), metaSourceTable.getTargetTableKey()}));
                }
                MetaColumn metaField = (MetaColumn)metaTable.get(sourceField.getTargetFieldKey());
                if (metaField != null) continue;
                throw new MetaException(33, SimpleStringFormat.format((String)StringTable.getString(null, "", "MapTargetFieldMiss"), (Object[])new Object[]{sourceField.getTargetFieldKey(), metaSourceTable.getTargetTableKey()}));
            }
            for (MetaSourceField f : reomveEmptyColumns) {
                metaSourceTable.remove(f);
            }
            if (metaSourceTable.isPrimary() || metaSourceTable.size() != 0) continue;
            reomveEmptyTables.add(metaSourceTable);
            this.refFieldMap.remove(metaSourceTable.getKey());
        }
        for (MetaSourceTable metaSourceTable : reomveEmptyTables) {
            meta.getSourceTableCollection().remove(metaSourceTable.getKey());
        }
        for (MetaTable metaTable : srcDataObject.getTableCollection()) {
            if (metaTable.getTableMode() != 0 || meta.getSourceTable(metaTable.getKey()) == null) continue;
            this.sourceHeadTableList.add(metaTable.getKey());
        }
        for (MetaTable metaTable : tgtDataObject.getTableCollection()) {
            if (metaTable.getTableMode() != 0 || meta.getTargetTableCollection().get(metaTable.getKey()) == null) continue;
            this.targetHeadTableList.add(metaTable.getKey());
        }
        this.needMapValue = (this.mapKeyField != null || this.focusField != null) && meta.getMapRelationValue() != false;
        this.primaryMapEdge = this.getNewEdge(meta, this.primarySourceTableKey, srcDataObject, tgtDataObject);
        HashMap<String, MetaMapEdge> edgeMap = new HashMap<String, MetaMapEdge>();
        edgeMap.put(this.primarySourceTableKey, this.primaryMapEdge);
        do {
            bl = false;
            for (KeyPairMetaObject table : srcDataObject.getTableCollection()) {
                String parentKey = ((MetaTable)table).getLevelID() == 2 ? srcDataObject.getMainTableKey() : ((MetaTable)table).getParentKey();
                MetaMapEdge parentEdge = (MetaMapEdge)edgeMap.get(parentKey);
                MetaMapEdge edge = (MetaMapEdge)edgeMap.get(((MetaTable)table).getKey());
                if (parentEdge == null || edge != null || meta.getSourceTable(((MetaTable)table).getKey()) == null) continue;
                edge = this.getNewEdge(meta, ((MetaTable)table).getKey(), srcDataObject, tgtDataObject);
                parentEdge.putChildEdgeList(edge);
                edgeMap.put(edge.getSourceTableKey(), edge);
                if (((MetaTable)table).getLevelID() == 2) {
                    edge.setMainTableParent(true);
                }
                bl = true;
            }
        } while (bl);
        for (KeyPairMetaObject table : meta.getSourceTableCollection()) {
            iterator = ((GenericNoKeyCollectionWithKey)table).iterator();
            while (iterator.hasNext()) {
                field = (MetaSourceField)iterator.next();
                if (((MetaSourceField)field).getTargetTableKey() == null || ((MetaSourceField)field).getTargetTableKey().length() == 0) {
                    ((MetaSourceField)field).setTargetTableKey(((MetaSourceTable)table).getTargetTableKey());
                }
                if (((MetaSourceField)field).getTargetFieldKey() == null || ((MetaSourceField)field).getTargetFieldKey().length() == 0) continue;
                MetaColumn column = (MetaColumn)tgtDataObject.getMetaTable(((MetaSourceField)field).getTargetTableKey()).get(((MetaSourceField)field).getTargetFieldKey());
                ((MetaSourceField)field).setTargetFieldAccessControl(column.isAccessControl());
                Integer dataType = column.getDataType();
                if (((MetaSourceField)field).getType() == 2) {
                    ((MetaSourceField)field).setConstValue(ConstUtil.getValue((String)((MetaSourceField)field).getDefinition(), (int)dataType));
                    continue;
                }
                if (((MetaSourceField)field).getType() == 0) {
                    Integer srcDataType2 = ((MetaColumn)srcDataObject.getMetaTable(((MetaSourceTable)table).getKey()).get(((MetaSourceField)field).getDefinition())).getDataType();
                    if (srcDataType2.equals(dataType)) continue;
                    ((MetaSourceField)field).setNeedTypeConvert(true);
                    ((MetaSourceField)field).setTargetFieldDataType(dataType);
                    continue;
                }
                ((MetaSourceField)field).setNeedTypeConvert(true);
                ((MetaSourceField)field).setTargetFieldDataType(dataType);
            }
        }
        for (KeyPairMetaObject table : meta.getTargetTableCollection()) {
            iterator = ((GenericNoKeyCollectionWithKey)table).iterator();
            while (iterator.hasNext()) {
                field = (MetaTargetField)iterator.next();
                Iterator iterator2 = ((GenericNoKeyCollection)field).iterator();
                while (iterator2.hasNext()) {
                    String path;
                    MetaFeedback fb = (MetaFeedback)iterator2.next();
                    MetaColumn tgtField = (MetaColumn)factory.getDataObject(fb.getDataObjectKey()).getMetaTable(fb.getTableKey()).get(fb.getFieldKey());
                    fb.setTargetFieldDataType(tgtField.getDataType());
                    if (((MetaTargetField)field).getType() == 2) {
                        fb.setConstValue(ConstUtil.getValue((String)((MetaTargetField)field).getDefinition(), (int)tgtField.getDataType()));
                    } else if (((MetaTargetField)field).getType() == 0) {
                        MetaColumn src = (MetaColumn)tgtDataObject.getMetaTable(((MetaTargetTable)table).getKey()).get(((MetaTargetField)field).getDefinition());
                        if (src.getDataType() != tgtField.getDataType()) {
                            fb.setNeedTypeConvert(true);
                        }
                    } else {
                        fb.setNeedTypeConvert(true);
                    }
                    if (fb.getPostTrigger() == null || (path = fb.getPostTrigger().getContent().trim()) == null || path.length() <= 0) continue;
                    fb.setPostClassPath(path);
                }
            }
        }
    }

    public static void logicCheck(MetaMap meta) throws Throwable {
        if (meta.getAllowSurplus().booleanValue() && (meta.getMaxPushValue() == null || meta.getMaxPushValue().length() == 0)) {
            throw new MetaException(32, SimpleStringFormat.format((String)StringTable.getString(null, "", "MaxPushValueUndefined"), (Object[])new Object[]{meta.getKey()}));
        }
    }

    private MetaMapEdge getNewEdge(MetaMap meta, String sourceTableKey, MetaDataObject srcDataObject, MetaDataObject tgtDataObject) {
        MetaMapEdge edge = new MetaMapEdge(sourceTableKey);
        edge.searchEdgeMap(meta, srcDataObject, tgtDataObject);
        return edge;
    }

    public MetaMapEdge getPrimaryMapEdge() {
        return this.primaryMapEdge;
    }

    public String getKey() {
        return this.key;
    }

    public HashMap<String, RefFieldMap> getRefFieldMap() {
        return this.refFieldMap;
    }

    public String getPrimarySourceTableKey() {
        return this.primarySourceTableKey;
    }

    public MetaSourceField getFocusField() {
        return this.focusField;
    }

    public String getPrimaryTgtTableKey() {
        return this.primaryTgtTableKey;
    }

    public ArrayList<String> getSourceHeadTableList() {
        return this.sourceHeadTableList;
    }

    public ArrayList<String> getTargetHeadTableList() {
        return this.targetHeadTableList;
    }

    public MetaMap getMeta() {
        return this.meta;
    }

    public MetaSourceField getMapKeyField() {
        return this.mapKeyField;
    }

    public boolean isNeedMapValue() {
        return this.needMapValue;
    }

    public Integer getTgtFocusFieldDataType() {
        return this.tgtFocusFieldDataType;
    }

    public boolean isNegtive() {
        return this.isNegtive;
    }

    public void setNegtive(boolean isNegtive) {
        this.isNegtive = isNegtive;
    }
}

