/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.charging;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.charging.MetaChargingTargetField;
import java.util.LinkedList;

public class MetaChargingTargetObject
extends GenericNoKeyCollection<MetaChargingTargetField> {
    public static final int ONLY_INSERT = 0;
    public static final String STR_ONLY_INSERT = "OnlyInsert";
    public static final int UPDATE_FIRST = 1;
    public static final String STR_UPDATE_FIRST = "UpdateFirst";
    public static final int GROUP_ONLY_INSERT = 2;
    public static final String STR_GROUP_ONLY_INSERT = "GroupOnlyInsert";
    private String objectKey = "";
    private String tableKey = "";
    private int policy = 1;
    public static final String TAG_NAME = "TargetObject";

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public void setTableKey(String tableKey) {
        this.tableKey = tableKey;
    }

    public String getTableKey() {
        return this.tableKey;
    }

    public void setPolicy(int policy) {
        this.policy = policy;
    }

    public int getPolicy() {
        return this.policy;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        MetaChargingTargetField resultMetaObject = null;
        if ("TargetField".equals(tagName)) {
            MetaChargingTargetField field = new MetaChargingTargetField();
            this.add(field);
            resultMetaObject = field;
        }
        return resultMetaObject;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaChargingTargetObject newObject = (MetaChargingTargetObject)this.newInstance();
        newObject.setObjectKey(this.objectKey);
        newObject.setTableKey(this.tableKey);
        newObject.setPolicy(this.policy);
        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaChargingTargetObject();
    }

    public static int parsePolicy(String s) {
        int policy = -1;
        if (STR_ONLY_INSERT.equalsIgnoreCase(s)) {
            policy = 0;
        } else if (STR_UPDATE_FIRST.equalsIgnoreCase(s)) {
            policy = 1;
        } else if (STR_GROUP_ONLY_INSERT.equalsIgnoreCase(s)) {
            policy = 2;
        }
        return policy;
    }

    public static String toPolicyString(int policy) {
        String s = "";
        switch (policy) {
            case 0: {
                s = STR_ONLY_INSERT;
                break;
            }
            case 1: {
                s = STR_UPDATE_FIRST;
                break;
            }
            case 2: {
                s = STR_GROUP_ONLY_INSERT;
            }
        }
        return s;
    }
}

