/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.bpm.process;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.migration.MetaDMTable;
import com.bokesoft.yigo.meta.bpm.process.attachment.MetaAttachmentCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaAssistanceCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMInfoCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlineCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaParticipatorCollection;
import com.bokesoft.yigo.meta.bpm.process.event.MetaEventCollection;
import com.bokesoft.yigo.meta.bpm.process.expand.MetaExpand;
import com.bokesoft.yigo.meta.bpm.process.multipleform.MetaRefFormCollection;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAnchor;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAudit;
import com.bokesoft.yigo.meta.bpm.process.node.MetaBegin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaBranchEnd;
import com.bokesoft.yigo.meta.bpm.process.node.MetaComplexJoin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaCountersign;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDataMap;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDecision;
import com.bokesoft.yigo.meta.bpm.process.node.MetaEnd;
import com.bokesoft.yigo.meta.bpm.process.node.MetaEvent;
import com.bokesoft.yigo.meta.bpm.process.node.MetaExclusiveFork;
import com.bokesoft.yigo.meta.bpm.process.node.MetaExclusiveJoin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaFork;
import com.bokesoft.yigo.meta.bpm.process.node.MetaGateWay;
import com.bokesoft.yigo.meta.bpm.process.node.MetaInline;
import com.bokesoft.yigo.meta.bpm.process.node.MetaJoin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaManualTask;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMessageReceive;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMessageSend;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMultiAudit;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMultiUserTask;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.node.MetaServiceTask;
import com.bokesoft.yigo.meta.bpm.process.node.MetaState;
import com.bokesoft.yigo.meta.bpm.process.node.MetaStateAction;
import com.bokesoft.yigo.meta.bpm.process.node.MetaSubProcess;
import com.bokesoft.yigo.meta.bpm.process.node.MetaTimer;
import com.bokesoft.yigo.meta.bpm.process.node.MetaUserTask;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPermCollection;
import com.bokesoft.yigo.meta.bpm.process.perm.extend.MetaInitiatorPermCollection;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransition;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransitionCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaProcess
extends GenericKeyCollection<MetaNode> {
    public static final String TAG_NAME = "Process";
    private String key = "";
    private String caption = "";
    private int idSeed = 0;
    private int version = 1;
    private String formKey = "";
    private String templateKey = "";
    private Boolean ignoreFormState = null;
    private boolean queryRetreatWorkitem = true;
    private String killInstanceTrigger = "";
    private MetaExpand expand = null;
    private int lockWorkitem = 0;
    private MetaSwimlineCollection swimlineCollection = new MetaSwimlineCollection();
    private MetaBPMInfoCollection BPMInfoCollection = new MetaBPMInfoCollection();
    private MetaDMTable dataMigrationTable = new MetaDMTable();
    private MetaPermCollection permCollection = new MetaPermCollection();
    private MetaInitiatorPermCollection initiatorPermCollection = new MetaInitiatorPermCollection();
    private MetaAttachmentCollection attachmentCollection = new MetaAttachmentCollection();
    private MetaParticipatorCollection globalptorCollection = null;
    private MetaEventCollection eventCollection = null;
    private MetaRefFormCollection refFormCollection = null;
    private TreeMap<Integer, MetaNode> nodeMapByID = null;
    private TreeMap<Integer, Integer> assistanceMapByID = null;
    private HashMap<String, String> assistanceMapByKey = null;
    private TreeMap<Integer, MetaNode> assistanceNodeMap = null;
    private HashMap<Integer, ArrayList<Integer>> preNodesMap = null;
    private boolean allowRevokeAfterEnd = true;

    public MetaExpand getExpand() {
        return this.expand;
    }

    public void setExpand(MetaExpand expand) {
        this.expand = expand;
    }

    public MetaSwimlineCollection getSwimlineCollection() {
        return this.swimlineCollection;
    }

    public void setSwimlineCollection(MetaSwimlineCollection swimlineCollection) {
        this.swimlineCollection = swimlineCollection;
    }

    public MetaBPMInfoCollection getBPMInfoCollection() {
        return this.BPMInfoCollection;
    }

    public void setBPMInfoCollection(MetaBPMInfoCollection BPMInfoCollection) {
        this.BPMInfoCollection = BPMInfoCollection;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        list.add(this.expand);
        list.add(this.swimlineCollection);
        list.add(this.BPMInfoCollection);
        list.add(this.dataMigrationTable);
        list.add(this.permCollection);
        list.add(this.attachmentCollection);
        list.add(this.globalptorCollection);
        list.add(this.eventCollection);
        list.add(this.refFormCollection);
        list.add(this.initiatorPermCollection);
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    private MetaNode createNode(String tagName) {
        MetaNode child = null;
        if (tagName.equalsIgnoreCase("Audit")) {
            child = new MetaAudit();
        } else if (tagName.equalsIgnoreCase("Begin")) {
            child = new MetaBegin();
        } else if (tagName.equalsIgnoreCase("Countersign")) {
            child = new MetaCountersign();
        } else if (tagName.equalsIgnoreCase("Decision")) {
            child = new MetaDecision();
        } else if (tagName.equalsIgnoreCase("End")) {
            child = new MetaEnd();
        } else if (tagName.equalsIgnoreCase("Event")) {
            child = new MetaEvent();
        } else if (tagName.equalsIgnoreCase("Fork")) {
            child = new MetaFork();
        } else if (tagName.equalsIgnoreCase("Join")) {
            child = new MetaJoin();
        } else if (tagName.equalsIgnoreCase("State")) {
            child = new MetaState();
        } else if (tagName.equalsIgnoreCase("SubProcess")) {
            child = new MetaSubProcess();
        } else if (tagName.equalsIgnoreCase("UserTask")) {
            child = new MetaUserTask();
        } else if (tagName.equalsIgnoreCase("Timer")) {
            child = new MetaTimer();
        } else if (tagName.equalsIgnoreCase("Inline")) {
            child = new MetaInline();
        } else if (tagName.equalsIgnoreCase("DataMap")) {
            child = new MetaDataMap();
        } else if (tagName.equalsIgnoreCase("ComplexJoin")) {
            child = new MetaComplexJoin();
        } else if (tagName.equalsIgnoreCase("ExclusiveFork")) {
            child = new MetaExclusiveFork();
        } else if (tagName.equalsIgnoreCase("ManualTask")) {
            child = new MetaManualTask();
        } else if (tagName.equalsIgnoreCase("ServiceTask")) {
            child = new MetaServiceTask();
        } else if (tagName.equalsIgnoreCase("BranchEnd")) {
            child = new MetaBranchEnd();
        } else if (tagName.equalsIgnoreCase("StateAction")) {
            child = new MetaStateAction();
        } else if (tagName.equalsIgnoreCase("MultiUserTask")) {
            child = new MetaMultiUserTask();
        } else if (tagName.equalsIgnoreCase("MultiAudit")) {
            child = new MetaMultiAudit();
        } else if (tagName.equalsIgnoreCase("GateWay")) {
            child = new MetaGateWay();
        } else if (tagName.equalsIgnoreCase("MessageSend")) {
            child = new MetaMessageSend();
        } else if (tagName.equalsIgnoreCase("MessageReceive")) {
            child = new MetaMessageReceive();
        } else if (tagName.equalsIgnoreCase("ExclusiveJoin")) {
            child = new MetaExclusiveJoin();
        } else if (tagName.equalsIgnoreCase("Anchor")) {
            child = new MetaAnchor();
        }
        return child;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        MetaNode child = this.createNode(tagName);
        if (child != null) {
            child.preProcessMetaObject(env, doc, node, flag, runType);
            this.add(child);
            return child;
        }
        AbstractMetaObject amo = null;
        if (tagName.equalsIgnoreCase("SwimlineCollection")) {
            this.swimlineCollection = new MetaSwimlineCollection();
            amo = this.swimlineCollection;
            amo.preProcessMetaObject(env, doc, node, flag, runType);
        } else if (tagName.equalsIgnoreCase("BPMInfoCollection")) {
            this.BPMInfoCollection = new MetaBPMInfoCollection();
            amo = this.BPMInfoCollection;
            amo.preProcessMetaObject(env, doc, node, flag, runType);
        } else if (tagName.equalsIgnoreCase("DMTable")) {
            this.dataMigrationTable = new MetaDMTable();
            amo = this.dataMigrationTable;
            amo.preProcessMetaObject(env, doc, node, flag, runType);
        } else if (tagName.equalsIgnoreCase("PermCollection")) {
            this.permCollection = new MetaPermCollection();
            amo = this.permCollection;
            amo.preProcessMetaObject(env, doc, node, flag, runType);
        } else if (tagName.equalsIgnoreCase("AttachmentCollection")) {
            this.attachmentCollection = new MetaAttachmentCollection();
            amo = this.attachmentCollection;
            amo.preProcessMetaObject(env, doc, node, flag, runType);
        } else if (tagName.equalsIgnoreCase("ParticipatorCollection")) {
            this.globalptorCollection = new MetaParticipatorCollection();
            amo = this.globalptorCollection;
            amo.preProcessMetaObject(env, doc, node, flag, runType);
        } else if (tagName.equalsIgnoreCase("Expand")) {
            this.expand = new MetaExpand();
            amo = this.expand;
            amo.preProcessMetaObject(env, doc, node, flag, runType);
        } else if (tagName.equalsIgnoreCase("EventCollection")) {
            this.eventCollection = new MetaEventCollection();
            amo = this.eventCollection;
            amo.preProcessMetaObject(env, doc, node, flag, runType);
        } else if (tagName.equalsIgnoreCase("RefFormCollection")) {
            this.refFormCollection = new MetaRefFormCollection();
            amo = this.refFormCollection;
            amo.preProcessMetaObject(env, doc, node, flag, runType);
        } else if (tagName.equalsIgnoreCase("InitiatorPermCollection")) {
            this.initiatorPermCollection = new MetaInitiatorPermCollection();
            amo = this.initiatorPermCollection;
            amo.preProcessMetaObject(env, doc, node, flag, runType);
        }
        return amo;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaProcess();
    }

    public int getVersion() {
        return this.version;
    }

    public int getIdSeed() {
        return this.idSeed;
    }

    public void setIdSeed(int idSeed) {
        this.idSeed = idSeed;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public String getTemplateKey() {
        return this.templateKey;
    }

    public void setTemplateKey(String template) {
        this.templateKey = template;
    }

    public Boolean getIgnoreFormState() {
        return this.ignoreFormState;
    }

    public void setIgnoreFormState(Boolean ignoreFormState) {
        this.ignoreFormState = ignoreFormState;
    }

    public boolean getQueryRetreatWorkitem() {
        return this.queryRetreatWorkitem;
    }

    public void setQueryRetreatWorkitem(boolean queryRetreatWorkitem) {
        this.queryRetreatWorkitem = queryRetreatWorkitem;
    }

    public int getLockWorkitem() {
        return this.lockWorkitem;
    }

    public void setLockWorkitem(int lockWorkitem) {
        this.lockWorkitem = lockWorkitem;
    }

    public String getKillInstanceTrigger() {
        return this.killInstanceTrigger;
    }

    public void setKillInstanceTrigger(String killInstanceTrigger) {
        this.killInstanceTrigger = killInstanceTrigger;
    }

    public MetaNode getNodeByID(int nodeID) {
        MetaNode node = this.nodeMapByID.get(nodeID);
        if (node != null) {
            return node;
        }
        if (this.assistanceNodeMap != null) {
            return this.assistanceNodeMap.get(nodeID);
        }
        return null;
    }

    public MetaDMTable getDataMigrationTable() {
        return this.dataMigrationTable;
    }

    public void setDataMigrationTable(MetaDMTable dataMigrationTable) {
        this.dataMigrationTable = dataMigrationTable;
    }

    public MetaPermCollection getPermCollection() {
        return this.permCollection;
    }

    public void setPermCollection(MetaPermCollection permCollection) {
        this.permCollection = permCollection;
    }

    public void setInitiatorPermCollection(MetaInitiatorPermCollection initiatorPermCollection) {
        this.initiatorPermCollection = initiatorPermCollection;
    }

    public MetaInitiatorPermCollection getInitiatorPermCollection() {
        return this.initiatorPermCollection;
    }

    public MetaAttachmentCollection getAttachmentCollection() {
        return this.attachmentCollection;
    }

    public void setAttachmentCollection(MetaAttachmentCollection attachmentCollection) {
        this.attachmentCollection = attachmentCollection;
    }

    public MetaParticipatorCollection getGlobeptorsCollection() {
        return this.globalptorCollection;
    }

    public void setGlobeptorsCollection(MetaParticipatorCollection globeptorsCollection) {
        this.globalptorCollection = globeptorsCollection;
    }

    public MetaEventCollection getEventCollection() {
        return this.eventCollection;
    }

    public void setEventCollection(MetaEventCollection eventCollection) {
        this.eventCollection = eventCollection;
    }

    public MetaRefFormCollection getRefFormCollection() {
        return this.refFormCollection;
    }

    public void setRefFormCollection(MetaRefFormCollection refFormCollection) {
        this.refFormCollection = refFormCollection;
    }

    public boolean isAllowRevokeAfterEnd() {
        return this.allowRevokeAfterEnd;
    }

    private void prepareAttributeByEndNode(MetaEnd metaEnd) {
        this.allowRevokeAfterEnd = metaEnd.isWorkitemRevoke();
    }

    public void doPostProcess() throws MetaException {
        this.nodeMapByID = new TreeMap();
        this.assistanceMapByID = new TreeMap();
        this.assistanceMapByKey = new HashMap();
        this.assistanceNodeMap = new TreeMap();
        MetaBegin begin = null;
        this.preNodesMap = new HashMap();
        for (MetaNode n : this.elementMap.values()) {
            MetaNode node2;
            Object ut;
            MetaAssistanceCollection ass;
            this.nodeMapByID.put(n.getID(), n);
            if (n instanceof MetaBegin) {
                begin = (MetaBegin)n;
            }
            if (n instanceof MetaEnd) {
                this.prepareAttributeByEndNode((MetaEnd)n);
            }
            if (n instanceof MetaUserTask && (ass = ((MetaUserTask)(ut = (MetaUserTask)n)).getAssistanceCollection()) != null && ass.size() > 0) {
                for (MetaNode node2 : ass) {
                    this.assistanceMapByID.put(node2.getID(), n.getID());
                    this.assistanceMapByKey.put(node2.getKey(), n.getKey());
                }
            }
            this.buildAssistanceNodeMap(n);
            ut = n.getTransitionCollection().iterator();
            while (ut.hasNext()) {
                MetaTransition t = (MetaTransition)ut.next();
                String nodeKey = t.getTargetNodeKey();
                node2 = (MetaNode)this.elementMap.get((Object)nodeKey);
                if (node2.getNodeType() == 8) {
                    MetaJoin mj = (MetaJoin)node2;
                    mj.setJoinCount(mj.getJoinCount() + 1);
                }
                t.setTargetNode(node2);
            }
            if (n.getNodeType() == 10) {
                boolean useStateTask = true;
                for (MetaTransition t : n.getTransitionCollection()) {
                    if (!(t instanceof MetaSequenceFlow)) continue;
                    node2 = t.getTargetNode();
                    if (node2.getNodeType() != 19) {
                        useStateTask = false;
                        break;
                    }
                    ((MetaStateAction)node2).setStateNode((MetaState)n);
                }
                ((MetaState)n).setUseStateTask(useStateTask);
            }
            if (n.getNodeType() == 19) {
                MetaStateAction node3 = (MetaStateAction)n;
                node3.getOperation().setCustomKey(n.getKey());
            }
            this.calPreNodes(n);
            if (!(n instanceof MetaUserTask) || (ass = (ut = (MetaUserTask)n).getAssistanceCollection()) == null || ass.size() <= 0) continue;
            for (MetaNode node2 : ass) {
                this.calPreNodes(node2);
            }
        }
        this.traversal(begin);
        this.checkForkJoin();
        this.mateForkJoin();
    }

    private void buildAssistanceNodeMap(MetaNode n) {
        MetaUserTask ut;
        MetaAssistanceCollection ass;
        if (n instanceof MetaUserTask && (ass = (ut = (MetaUserTask)n).getAssistanceCollection()) != null && ass.size() > 0) {
            for (MetaNode node : ass) {
                this.assistanceNodeMap.put(node.getID(), node);
                this.buildAssistanceNodeMap(node);
            }
        }
    }

    private void traversal(MetaBegin begin) {
        begin.setDeep(0);
        begin.setMarked();
        LinkedList queue = new LinkedList();
        Map map = new HashMap<Integer, MetaBegin>();
        map.put(begin.getID(), begin);
        queue.offer(map);
        while (queue.size() > 0) {
            map = (Map)queue.poll();
            for (MetaNode node : map.values()) {
                HashMap<Integer, MetaNode> loop = new HashMap<Integer, MetaNode>();
                for (MetaTransition t : node.getTransitionCollection()) {
                    MetaNode tNode = t.getTargetNode();
                    if (tNode.isMarked()) continue;
                    if (node.getNodeType() == 7 || node.getNodeType() == 16) {
                        tNode.setDeep(node.getDeep() + 1);
                    } else if (node.getNodeType() == 8 || node.getNodeType() == 14) {
                        tNode.setDeep(node.getDeep() - 1 < 0 ? 0 : node.getDeep() - 1);
                    } else {
                        tNode.setDeep(node.getDeep());
                    }
                    tNode.setMarked();
                    loop.put(tNode.getID(), tNode);
                }
                queue.add(loop);
            }
        }
    }

    private void checkForkJoin() {
        for (MetaNode node : this.elementMap.values()) {
            MetaNode n;
            MetaJoin join;
            int mateForkID;
            if (node.getNodeType() != 8 && node.getNodeType() != 14 || (mateForkID = (join = (MetaJoin)node).getMateForkID()) <= 0 || (n = this.getNodeByID(mateForkID)) == null || n.getNodeType() != 7) continue;
            join.setFork((MetaFork)n);
        }
    }

    private void mateForkJoin() {
        for (MetaNode n : this.elementMap.values()) {
            if (n.getNodeType() != 7) continue;
            TreeSet<Integer> set = new TreeSet<Integer>();
            boolean flag = false;
            int deep = 0;
            MetaTransitionCollection collection = n.getTransitionCollection();
            if (collection.size() == 0) continue;
            MetaNode tNode = ((MetaTransition)n.getTransitionCollection().get(0)).getTargetNode();
            set.add(tNode.getID());
            if (tNode.getNodeType() == 7) {
                ++deep;
            }
            while (tNode.getNodeType() != 8 && tNode.getNodeType() != 14 || deep > 0) {
                if (tNode.getNodeType() == 7) {
                    ++deep;
                }
                if ((tNode.getNodeType() == 8 || tNode.getNodeType() == 14) && deep > 0) {
                    --deep;
                }
                if ((collection = tNode.getTransitionCollection()).size() == 0) {
                    flag = true;
                    break;
                }
                if (set.contains((tNode = ((MetaTransition)tNode.getTransitionCollection().get(0)).getTargetNode()).getID())) {
                    flag = true;
                    break;
                }
                set.add(tNode.getID());
            }
            if (flag || ((MetaJoin)tNode).getFork() != null) continue;
            ((MetaJoin)tNode).setFork((MetaFork)n);
        }
    }

    public void release() {
        for (MetaNode node : this.elementMap.values()) {
            if (!node.isMarked()) continue;
            node.setUnMarked();
        }
    }

    private void calPreNodes(MetaNode node) {
        for (MetaTransition t : node.getTransitionCollection()) {
            String nodeKey = t.getTargetNodeKey();
            MetaNode n = (MetaNode)this.elementMap.get((Object)nodeKey);
            ArrayList<Integer> preNodes = this.preNodesMap.get(n.getID());
            if (preNodes == null) {
                preNodes = new ArrayList();
                this.preNodesMap.put(n.getID(), preNodes);
            }
            preNodes.add(node.getID());
        }
    }

    public ArrayList<Integer> getPreNodesById(Integer nodeId) {
        ArrayList<Integer> preNodes = this.preNodesMap.get(nodeId);
        if (preNodes != null && !preNodes.isEmpty()) {
            return preNodes;
        }
        return null;
    }

    public HashMap<String, String> getAssistanceMapByKey() {
        return this.assistanceMapByKey;
    }

    public TreeMap<Integer, Integer> getAssistanceMapByID() {
        return this.assistanceMapByID;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject obj = new JSONObject();
        obj.put("key", (Object)this.key);
        obj.put("caption", (Object)this.caption);
        obj.put("idSeed", this.idSeed);
        obj.put("version", this.version);
        JSONArray nodeArray = new JSONArray();
        Iterator itNode = this.elementMap.entrySet().iterator();
        Map.Entry entryNode = null;
        MetaNode node = null;
        while (itNode.hasNext()) {
            entryNode = (Map.Entry)itNode.next();
            node = (MetaNode)entryNode.getValue();
            JSONObject objNode = node.toJSON();
            nodeArray.put((Object)objNode);
        }
        obj.put("nodes", (Object)nodeArray);
        if (this.swimlineCollection != null) {
            JSONObject objSwinlines = this.swimlineCollection.toJSON();
            obj.put("swinlines", (Object)objSwinlines);
        }
        if (this.BPMInfoCollection != null) {
            JSONObject objBPMInfos = this.BPMInfoCollection.toJSON();
            obj.put("bpminfos", (Object)objBPMInfos);
        }
        if (this.dataMigrationTable != null) {
            JSONObject objDataMigrations = this.dataMigrationTable.toJSON();
            obj.put("datamigrations", (Object)objDataMigrations);
        }
        return obj;
    }

    @Override
    public void fromJSON(JSONObject json) {
        this.key = json.optString("key");
        this.caption = json.optString("caption");
        this.idSeed = json.optInt("idSeed");
        this.version = json.optInt("version");
        JSONArray nodeArray = json.optJSONArray("nodes");
        if (nodeArray != null) {
            int length = nodeArray.length();
            for (int i = 0; i < length; ++i) {
                JSONObject objNode = (JSONObject)nodeArray.get(i);
                String tagName = objNode.getString("tag-name");
                MetaNode node = this.createNode(tagName);
                node.fromJSON(objNode);
                this.add(node);
            }
        }
        if (json.has("swinlines")) {
            this.swimlineCollection = new MetaSwimlineCollection();
            this.swimlineCollection.fromJSON(json.getJSONObject("swinlines"));
        }
        if (json.has("bpminfos")) {
            this.BPMInfoCollection = new MetaBPMInfoCollection();
            this.BPMInfoCollection.fromJSON(json.getJSONObject("bpminfos"));
        }
        if (json.has("datamigrations")) {
            this.dataMigrationTable = new MetaDMTable();
            this.dataMigrationTable.fromJSON(json.getJSONObject("datamigrations"));
        }
    }

    @Override
    public AbstractMetaObject clone() {
        MetaProcess newProcess = (MetaProcess)super.clone();
        newProcess.setKey(this.key);
        newProcess.setCaption(this.caption);
        newProcess.setIdSeed(this.idSeed);
        newProcess.setVersion(this.version);
        newProcess.setFormKey(this.formKey);
        newProcess.setQueryRetreatWorkitem(this.queryRetreatWorkitem);
        newProcess.setSwimlineCollection(this.swimlineCollection == null ? null : (MetaSwimlineCollection)this.swimlineCollection.clone());
        newProcess.setBPMInfoCollection(this.BPMInfoCollection == null ? null : (MetaBPMInfoCollection)this.BPMInfoCollection.clone());
        newProcess.setDataMigrationTable(this.dataMigrationTable == null ? null : (MetaDMTable)this.dataMigrationTable.clone());
        newProcess.setPermCollection(this.permCollection == null ? null : (MetaPermCollection)this.permCollection.clone());
        newProcess.setAttachmentCollection(this.attachmentCollection == null ? null : (MetaAttachmentCollection)this.attachmentCollection.clone());
        newProcess.setGlobeptorsCollection(this.globalptorCollection == null ? null : (MetaParticipatorCollection)this.globalptorCollection.clone());
        newProcess.eventCollection = this.eventCollection == null ? null : (MetaEventCollection)this.eventCollection.clone();
        newProcess.refFormCollection = this.refFormCollection == null ? null : (MetaRefFormCollection)this.refFormCollection.clone();
        newProcess.setTemplateKey(this.templateKey);
        newProcess.setIgnoreFormState(this.ignoreFormState);
        newProcess.setKillInstanceTrigger(this.killInstanceTrigger);
        newProcess.setExpand(this.expand == null ? null : (MetaExpand)this.expand.clone());
        newProcess.setInitiatorPermCollection(this.initiatorPermCollection == null ? null : (MetaInitiatorPermCollection)this.initiatorPermCollection.clone());
        return newProcess;
    }
}

