/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.base;

import com.bokesoft.yes.common.struct.StringLinkedHashMap;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class GenericKeyCollection<T extends KeyPairMetaObject>
extends AbstractMetaObject
implements Iterable<T> {
    protected StringLinkedHashMap<T> elementMap = new StringLinkedHashMap();

    public T add(T element) {
        this.elementMap.put((Object)((KeyPairMetaObject)element).getKey(), element);
        return element;
    }

    public void addAll(List<T> items) {
        for (KeyPairMetaObject t : items) {
            this.add(t);
        }
    }

    public void remove(String key) {
        this.elementMap.remove((Object)key);
    }

    public T get(String key) {
        return (T)((KeyPairMetaObject)this.elementMap.get((Object)key));
    }

    public boolean containsKey(String key) {
        return this.elementMap.containsKey((Object)key);
    }

    @Override
    public Iterator<T> iterator() {
        return this.elementMap.values().iterator();
    }

    public Iterator<Map.Entry<String, T>> entryIterator() {
        return this.elementMap.entrySet().iterator();
    }

    public int size() {
        return this.elementMap.size();
    }

    public boolean isEmpty() {
        return this.elementMap.isEmpty();
    }

    public T get(int index) {
        return (T)((KeyPairMetaObject)this.elementMap.values().toArray()[index]);
    }

    public T first() {
        return (T)((KeyPairMetaObject)((Map.Entry)this.elementMap.entrySet().iterator().next()).getValue());
    }

    public void clear() {
        this.elementMap.clear();
    }

    @Override
    public void traversalCollectionObjects(IMetaEnv env, Object doc, Object node, Object flag, int runType) throws MetaException {
        Iterator itEntry = this.elementMap.entrySet().iterator();
        Map.Entry entry = null;
        while (itEntry.hasNext()) {
            entry = (Map.Entry)itEntry.next();
            KeyPairMetaObject element = (KeyPairMetaObject)entry.getValue();
            if (element.isAutoGen()) continue;
            Object childNode = env.prepare(element, node);
            element.traversal(env, doc, childNode, flag, runType);
        }
    }

    @Override
    public AbstractMetaObject clone() {
        GenericKeyCollection newObject = (GenericKeyCollection)this.newInstance();
        Iterator it = this.elementMap.entrySet().iterator();
        Map.Entry entry = null;
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            newObject.add((KeyPairMetaObject)((KeyPairMetaObject)entry.getValue()).clone());
        }
        return newObject;
    }
}

