/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.process;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;
import com.bokesoft.yigo.meta.form.component.control.MetaButton;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.MetaHyperLink;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaHyperLinkProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilterCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.panel.MetaPanel;
import java.util.Iterator;

public class MetaSubDetailProcess {
    private MetaForm metaForm;

    public MetaSubDetailProcess(MetaForm metaForm) {
        this.metaForm = metaForm;
    }

    public void process() {
        Iterator<MetaComponent> it = this.metaForm.getSubDetails().iterator();
        MetaSubDetail metaSub = null;
        while (it.hasNext()) {
            metaSub = (MetaSubDetail)it.next();
            String parentKey = metaSub.getBindingGridKey();
            if (parentKey == null || parentKey.isEmpty()) {
                throw new MetaException(54, SimpleStringFormat.format((String)StringTable.getString(null, "", "ParentGridNotFound"), (Object[])new Object[]{this.metaForm.getKey(), parentKey}));
            }
            MetaTableRow metaRow = this.metaForm.metaTableRowByKey(parentKey);
            if (metaRow != null && metaRow.getRowType() == 2) {
                metaRow.setHasSubDetail(true);
                this.impl_processSubDetail4MobileList(metaSub.getRoot(), metaRow);
                continue;
            }
            MetaComponent parent = this.metaForm.componentByKey(parentKey);
            if (parent instanceof MetaEditView) {
                ((MetaEditView)parent).setHasSubDetail(true);
                this.impl_processSubDetail4MobileList(metaSub.getRoot(), parent);
                continue;
            }
            MetaGrid parGrid = (MetaGrid)parent;
            parGrid.setHasSubDetail(true);
            this.impl_processSubDetail(metaSub.getRoot(), parGrid);
        }
    }

    private void impl_processSubDetail(MetaComponent rootCom, MetaGrid metaGrid) {
        if (rootCom.isPanel()) {
            MetaPanel metaPanel = (MetaPanel)rootCom;
            for (MetaComponent meta : metaPanel.getComponentArray()) {
                if (meta.getControlType() == 247) continue;
                if (meta.isPanel()) {
                    this.impl_processSubDetail(meta, metaGrid);
                    continue;
                }
                this.impl_processCom(meta, metaGrid);
            }
            rootCom.setParentGridKey(metaGrid.getKey());
        } else {
            this.impl_processCom(rootCom, metaGrid);
        }
    }

    private void impl_processCom(MetaComponent meta, MetaGrid metaGrid) {
        String gridKey = metaGrid.getKey();
        if (meta.getControlType() != 217) {
            if (meta.hasDataBinding().booleanValue() && meta.getTableKey().equals(metaGrid.getTableKey())) {
                meta.setParentGridKey(gridKey);
            }
            String cellKey = meta.getBindingCellKey();
            MetaGridCell bindCell = null;
            if (cellKey != null && !cellKey.isEmpty()) {
                meta.setParentGridKey(gridKey);
                bindCell = this.metaForm.metaGridCellByKey(cellKey);
            }
            if (meta.isSubDetail().booleanValue()) {
                MetaSubDetailProcess.impl_processAttrs(meta, metaGrid, bindCell);
            }
        } else {
            meta.setParentGridKey(gridKey);
        }
    }

    private static void impl_processAttrs(MetaComponent meta, MetaGrid metaGrid, MetaGridCell bindCell) {
        MetaBaseScript onclick = null;
        switch (meta.getControlType()) {
            case 200: {
                MetaBaseScript script;
                MetaButton metaButton = (MetaButton)meta;
                onclick = metaButton.getOnClick();
                if (onclick != null && !onclick.isEmpty() || bindCell == null || bindCell.getCellType() != 200 || (script = ((MetaButtonProperties)bindCell.getProperties()).getOnClick()) == null) break;
                metaButton.setOnClick((MetaBaseScript)script.clone());
                break;
            }
            case 208: {
                MetaBaseScript script;
                MetaHyperLink hyperLink = (MetaHyperLink)meta;
                onclick = hyperLink.getOnClick();
                if (onclick != null && !onclick.isEmpty() || bindCell == null || bindCell.getCellType() != 208 || (script = ((MetaHyperLinkProperties)bindCell.getProperties()).getOnClick()) == null) break;
                hyperLink.setOnClick((MetaBaseScript)script.clone());
                break;
            }
            case 206: {
                MetaItemFilterCollection itemFilters;
                MetaDict metaDict = (MetaDict)meta;
                MetaItemFilterCollection filters = metaDict.getFilters();
                if (filters != null && filters.size() != 0 || bindCell == null || bindCell.getCellType() != 206 || (itemFilters = ((MetaDictProperties)bindCell.getProperties()).getFilters()) == null) break;
                metaDict.getProperties().setFilters((MetaItemFilterCollection)itemFilters.clone());
                break;
            }
        }
    }

    private void impl_processSubDetail4MobileList(MetaComponent rootCom, MetaComponent parentCom) {
        if (rootCom.isPanel()) {
            MetaPanel metaPanel = (MetaPanel)rootCom;
            for (MetaComponent meta : metaPanel.getComponentArray()) {
                if (meta.getControlType() == 247) continue;
                if (meta.isPanel()) {
                    this.impl_processSubDetail4MobileList(meta, parentCom);
                    continue;
                }
                this.impl_processCom4MobileList(meta, parentCom);
            }
            rootCom.setParentGridKey(parentCom.getKey());
        } else {
            this.impl_processCom4MobileList(rootCom, parentCom);
        }
    }

    private void impl_processCom4MobileList(MetaComponent meta, MetaComponent parentCom) {
        String key = parentCom.getKey();
        if (meta instanceof MetaTableView) {
            MetaTableView tableView = (MetaTableView)meta;
            for (MetaTableRow row : tableView.getRows()) {
                row.setParentGridKey(parentCom.getKey());
                this.impl_processSubDetail4MobileList(row.getRoot(), parentCom);
            }
        } else if (meta instanceof MetaEditView) {
            meta.setParentGridKey(parentCom.getKey());
        } else {
            if (meta.hasDataBinding().booleanValue() && meta.getTableKey().equals(parentCom.getTableKey())) {
                meta.setParentGridKey(key);
            }
            String cellKey = meta.getBindingCellKey();
            MetaComponent cellComponent = null;
            if (cellKey != null && !cellKey.isEmpty()) {
                meta.setParentGridKey(key);
                cellComponent = this.metaForm.metaDetailComponentByKey(cellKey);
            }
            if (meta.isSubDetail().booleanValue()) {
                int cellType = cellComponent instanceof MetaEditViewColumn ? ((MetaEditViewColumn)cellComponent).getColumnType() : meta.getControlType();
                MetaSubDetailProcess.impl_processAttrs4MobileList(meta, parentCom, cellComponent, cellType);
            }
        }
    }

    private static void impl_processAttrs4MobileList(MetaComponent meta, MetaComponent parentCom, MetaComponent bindCell, int cellType) {
        MetaBaseScript onclick = null;
        switch (meta.getControlType()) {
            case 200: {
                MetaBaseScript script;
                MetaButton metaButton = (MetaButton)meta;
                onclick = metaButton.getOnClick();
                if (onclick != null && !onclick.isEmpty() || bindCell == null || cellType != 200 || (script = ((MetaButtonProperties)bindCell.getProperties()).getOnClick()) == null) break;
                metaButton.setOnClick((MetaBaseScript)script.clone());
                break;
            }
            case 208: {
                MetaBaseScript script;
                MetaHyperLink hyperLink = (MetaHyperLink)meta;
                onclick = hyperLink.getOnClick();
                if (onclick != null && !onclick.isEmpty() || bindCell == null || cellType != 208 || (script = ((MetaHyperLinkProperties)bindCell.getProperties()).getOnClick()) == null) break;
                hyperLink.setOnClick((MetaBaseScript)script.clone());
                break;
            }
            case 206: {
                MetaItemFilterCollection itemFilters;
                MetaDict metaDict = (MetaDict)meta;
                MetaItemFilterCollection filters = metaDict.getFilters();
                if (filters != null && filters.size() != 0 || bindCell == null || cellType != 206 || (itemFilters = ((MetaDictProperties)bindCell.getProperties()).getFilters()) == null) break;
                metaDict.getProperties().setFilters((MetaItemFilterCollection)itemFilters.clone());
                break;
            }
        }
    }
}

