/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.process;

import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class MetaDataObjectTemplateUtil {
    private MetaDataObject targetDataObject = null;
    private MetaDataObject sourceDataObject = null;
    private String tableKeys = "";
    private HashSet<String> sourceTables = null;
    private HashMap<String, Object> vars = null;

    public MetaDataObjectTemplateUtil(MetaDataObject sourceDataObject, MetaDataObject targetDataObject, String tableKeys, HashMap<String, Object> vars) throws Exception {
        if (sourceDataObject == null) {
            throw new Exception("\u76ee\u6807\u6570\u636e\u5bf9\u8c61" + targetDataObject.getKey() + "\u6ca1\u6709\u83b7\u53d6\u5230\u6e90\u6570\u636e\u5bf9\u8c61");
        }
        this.sourceDataObject = sourceDataObject;
        this.targetDataObject = targetDataObject;
        this.tableKeys = tableKeys;
        this.vars = vars;
    }

    public void replace() {
        if (this.tableKeys != null && !this.tableKeys.isEmpty()) {
            this.sourceTables = new HashSet();
            String[] v = this.tableKeys.split(",");
            int size = v.length;
            for (int i = 0; i < size; ++i) {
                this.sourceTables.add(v[i]);
            }
        }
        MetaTableCollection sourceTableCollection = this.sourceDataObject.getTableCollection();
        MetaTableCollection targetTableCollection = this.targetDataObject.getTableCollection();
        Iterator it = sourceTableCollection.entryIterator();
        Map.Entry entry = null;
        while (it.hasNext()) {
            MetaTable targetTable;
            String parentKey;
            entry = it.next();
            MetaTable metaTable = (MetaTable)entry.getValue();
            String key = metaTable.getKey();
            if (this.sourceTables != null && !this.sourceTables.contains(key)) continue;
            MetaTable newMetaTable = (MetaTable)metaTable.clone();
            newMetaTable.setKey(SimpleStringFormat.format_v2((String)key, this.vars));
            String dbKey = newMetaTable.getDBTableName();
            if (dbKey != null && !dbKey.isEmpty()) {
                newMetaTable.setDBTableName(SimpleStringFormat.format_v2((String)dbKey, this.vars));
            }
            if ((parentKey = metaTable.getParentKey()) != null && !parentKey.isEmpty()) {
                newMetaTable.setParentKey(SimpleStringFormat.format_v2((String)parentKey, this.vars));
            }
            if ((targetTable = (MetaTable)targetTableCollection.get(newMetaTable.getKey())) != null) {
                for (MetaColumn col : newMetaTable) {
                    if (targetTable.containsKey(col.getKey())) continue;
                    targetTable.add((MetaColumn)col.clone());
                }
                continue;
            }
            targetTableCollection.add(newMetaTable);
        }
    }
}

