/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.xml.parse;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.persist.dom.xml.ex.XmlSyntaxException;
import com.bokesoft.yes.meta.persist.dom.xml.parse.CharUtil;
import com.bokesoft.yes.meta.persist.dom.xml.parse.Element;
import com.bokesoft.yes.meta.persist.dom.xml.parse.Entry;
import com.bokesoft.yes.meta.persist.dom.xml.parse.TextAnalyzer;
import java.util.LinkedHashMap;
import java.util.Map;

public class PrivateUtil {
    public static Element getStartTag(String xml, int bgidx) {
        Element tag = new Element();
        tag.type = 0;
        int lowerIndex = -1;
        int tagNameEndIndex = -1;
        int upperIndex = -1;
        boolean isNodeClose = false;
        boolean findLower = false;
        boolean findingTagName = false;
        boolean foundTagName = false;
        boolean foundAttrs = false;
        boolean foundUpper = false;
        for (int i = bgidx; i < xml.length(); ++i) {
            char c = xml.charAt(i);
            if (!findLower) {
                if (c != '<') continue;
                findLower = true;
                lowerIndex = i;
                continue;
            }
            if (!findingTagName) {
                if (PrivateUtil.isNameStartChar(c)) {
                    findingTagName = true;
                    continue;
                }
                throw new XmlSyntaxException("\r\n<\u7b26\u53f7\u540e\u9762\u4e0d\u662f\u6b63\u786e\u7684\u6807\u7b7e\u5f00\u59cb\u7b26\u53f7[" + c + "]\r\n" + PrivateUtil.getErrorPosInfo(xml, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
            }
            if (!foundTagName) {
                if (PrivateUtil.isNameChar(c)) continue;
                if (CharUtil.isBlank(c)) {
                    foundTagName = true;
                    tagNameEndIndex = i;
                    continue;
                }
                if (c == '>' || c == '/') {
                    foundTagName = true;
                    tagNameEndIndex = i--;
                    continue;
                }
                throw new XmlSyntaxException("\r\n\u5bfb\u627e\u6807\u7b7e\u540d\u79f0[" + xml.substring(lowerIndex, i) + "]\u8fc7\u7a0b\u4e2d,\u9047\u5230\u4e0d\u5408\u6cd5\u7b26\u53f7[" + c + "]\r\n" + PrivateUtil.getErrorPosInfo(xml, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
            }
            if (!foundAttrs) {
                Object[] arr = PrivateUtil.getAttrs(xml, i, new char[]{'/', '>'});
                foundAttrs = true;
                if (arr != null) {
                    tag.attrs = (Map)arr[1];
                    int tem = (Integer)arr[0];
                    i = tem - 1;
                    continue;
                }
                --i;
                continue;
            }
            if (foundUpper) break;
            if (isNodeClose) {
                if (c != '>') {
                    throw new XmlSyntaxException("\r\n\u6807\u7b7e[" + xml.substring(lowerIndex, i + 1) + "]\u6ca1\u6709\u6b63\u786e\u7684\u95ed\u5408\r\n" + xml.substring(0, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n" + xml.substring(i));
                }
                foundUpper = true;
                upperIndex = i;
                continue;
            }
            if (c == '/') {
                isNodeClose = true;
                continue;
            }
            if (c == '>') {
                foundUpper = true;
                upperIndex = i;
                continue;
            }
            if (CharUtil.isBlank(c)) continue;
            throw new XmlSyntaxException("\r\n\u6807\u7b7e[" + xml.substring(lowerIndex, i + 1) + "]\u53ea\u80fd\u7528/> \u6216>\u7b26\u53f7\u6765\u5173\u95ed.\u975e\u6cd5\u5b57\u7b26[" + c + "]\r\n" + PrivateUtil.getErrorPosInfo(xml, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
        }
        if (!findLower) {
            throw new XmlSyntaxException("\r\n\u6ca1\u6709\u5408\u6cd5\u7684xml\u6807\u7b7e[" + xml + "]");
        }
        if (!findingTagName) {
            throw new XmlSyntaxException("\r\n\u6ca1\u6709\u5f00\u59cb\u786e\u8ba4\u6807\u7b7e\u540d\u79f0[" + xml + "]");
        }
        if (!foundTagName) {
            throw new XmlSyntaxException("\r\n\u6807\u7b7e\u540d\u79f0\u8fd8\u5904\u4e8e\u83b7\u53d6\u4e2dtagName[" + xml.substring(lowerIndex) + "]");
        }
        if (!foundUpper) {
            throw new XmlSyntaxException("\r\n\u6807\u7b7e\u6ca1\u6709\u6b63\u786e\u7684\u95ed\u5408[" + xml.substring(lowerIndex) + "]");
        }
        tag.bgIndex = lowerIndex;
        tag.endIndex = upperIndex;
        tag.tagName = xml.substring(lowerIndex + 1, tagNameEndIndex);
        tag.tagType = isNodeClose ? 3 : 1;
        return tag;
    }

    public static Element getEndTag(String xml, int bg) {
        if (xml == null || xml.length() - bg < 4) {
            throw new XmlSyntaxException("\r\ngetEndTag [" + xml.substring(bg) + "] \u660e\u663e\u4e0d\u662f\u5408\u6cd5\u7684\u7ed3\u5c3e\u6807\u7b7e\u683c\u5f0f.");
        }
        int i = xml.indexOf("</", bg);
        if (i == -1) {
            throw new XmlSyntaxException("\r\ngetEndTag [" + xml.substring(bg) + "] \u660e\u663e\u4e0d\u662f\u5408\u6cd5\u7684\u7ed3\u5c3e\u6807\u7b7e\u683c\u5f0f.");
        }
        Element ele = new Element();
        ele.bgIndex = i;
        i += 2;
        boolean findingTagName = false;
        boolean foundTagName = false;
        boolean foundGt = false;
        ele.type = 0;
        ele.tagType = 2;
        int nameBg = -1;
        while (i < xml.length()) {
            char c = xml.charAt(i);
            if (!findingTagName) {
                if (!PrivateUtil.isNameStartChar(c)) {
                    throw new XmlSyntaxException("\r\ngetEndTag: [" + c + "]\u4e0d\u662f\u6b63\u786e\u7684name\u5f00\u59cb\u5b57\u7b26\r\n" + PrivateUtil.getErrorPosInfo(xml, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
                }
                findingTagName = true;
                nameBg = i;
            } else if (!foundTagName) {
                if (CharUtil.isBlank(c)) {
                    foundTagName = true;
                    ele.tagName = xml.substring(nameBg, i);
                } else if (c == '>') {
                    foundTagName = true;
                    ele.tagName = xml.substring(nameBg, i);
                    foundGt = true;
                    ele.endIndex = i;
                } else if (!PrivateUtil.isNameChar(c)) {
                    throw new XmlSyntaxException("\r\ngetEndTag: [" + c + "]\u4e0d\u662f\u6b63\u786e\u7684\u540d\u79f0\u5b57\u7b26\r\n" + PrivateUtil.getErrorPosInfo(xml, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
                }
            } else {
                if (foundGt) break;
                if (c == '>') {
                    foundGt = true;
                    ele.endIndex = i;
                } else if (!CharUtil.isBlank(c)) {
                    throw new XmlSyntaxException("\r\ngetEndTag: Tag[" + ele.tagName + "] \u540e\u9762\u9047\u5230\u4e0d\u5408\u6cd5\u7684\u95ed\u5408\u5b57\u7b26[" + c + "]\r\n" + PrivateUtil.getErrorPosInfo(xml, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
                }
            }
            ++i;
        }
        return ele;
    }

    public static Object[] getAttrs(String xml, int bgidx, char[] endChars) {
        int argsEndIndex = -1;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int p1 = -1;
        String name = null;
        String value = null;
        char valueStartChar = '0';
        boolean findingName = false;
        boolean foundName = false;
        boolean findEq = false;
        boolean findingValue = false;
        boolean foundValue = false;
        for (int i = bgidx; i < xml.length(); ++i) {
            char c = xml.charAt(i);
            if (!findingName) {
                if (PrivateUtil.isEndChar(c, endChars)) {
                    if (map.size() != 0) {
                        Object[] tem = new Object[]{argsEndIndex, map};
                        return tem;
                    }
                    return null;
                }
                if (CharUtil.isBlank(c)) continue;
                if (PrivateUtil.isNameStartChar(c)) {
                    findingName = true;
                    p1 = i;
                    continue;
                }
                throw new XmlSyntaxException("\r\n\u5c5e\u6027\u540d\u79f0\u5f00\u59cb\u5b57\u7b26\u4e0d\u5408\u6cd5[" + c + "]\r\n" + PrivateUtil.getErrorPosInfo(xml, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
            }
            if (!foundName) {
                if (PrivateUtil.isNameChar(c)) continue;
                if (CharUtil.isBlank(c)) {
                    foundName = true;
                    name = xml.substring(p1, i);
                    continue;
                }
                if (c == '=') {
                    foundName = true;
                    name = xml.substring(p1, i);
                    findEq = true;
                    continue;
                }
                throw new XmlSyntaxException("\r\n\u5c5e\u6027\u540d\u79f0\u9047\u5230\u4e0d\u5408\u6cd5\u5b57\u7b26[" + c + "]\r\n" + PrivateUtil.getErrorPosInfo(xml, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
            }
            if (!findEq) {
                if (CharUtil.isBlank(c)) continue;
                if (c == '=') {
                    findEq = true;
                    continue;
                }
                throw new XmlSyntaxException("\r\n\u83b7\u53d6\u5c5e\u6027\u540d\u79f0\u540e\u56e0\u8be5\u6709\u4e00\u4e2a=\u53f7,\u73b0\u5728\u662f\u975e\u6cd5\u5b57\u7b26[" + c + "]" + PrivateUtil.getErrorPosInfo(xml, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
            }
            if (!findingValue) {
                if (CharUtil.isBlank(c)) continue;
                if (c == '\"' || c == '\'') {
                    findingValue = true;
                    p1 = i;
                    valueStartChar = c;
                    continue;
                }
                throw new XmlSyntaxException("\r\ngetArgs:\u5c5e\u6027[" + name + "]\u503c\u7684\u5f00\u59cb\uff0c\u56e0\u8be5\u4e3a[']\u6216[\"].");
            }
            if (!foundValue) {
                if (c != valueStartChar) continue;
                foundValue = true;
                value = xml.substring(p1 + 1, i);
                map.put(name, value);
                continue;
            }
            if (CharUtil.isBlank(c)) {
                findingName = false;
                foundName = false;
                findEq = false;
                findingValue = false;
                foundValue = false;
                argsEndIndex = i;
                continue;
            }
            if (PrivateUtil.isEndChar(c, endChars)) {
                Object[] obj = new Object[]{i, map};
                return obj;
            }
            throw new XmlSyntaxException("\r\n\u5c5e\u6027[" + name + "]\u7ed3\u675f\u540e\uff0c\u4e0d\u80fd\u7d27\u8ddf\u5b57\u7b26[" + c + "]\r\n" + PrivateUtil.getErrorPosInfo(xml, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
        }
        if (!findingName) {
            if (map.size() == 0) {
                return null;
            }
            Object[] arr = new Object[]{argsEndIndex, map};
            return arr;
        }
        if (foundValue) {
            Object[] temArr = new Object[]{xml.length(), map};
            return temArr;
        }
        if (!foundName) {
            throw new XmlSyntaxException("\r\nXmlUtil :getStartTag:getArgs:\u5c5e\u6027\u540d\u79f0\u8fd8\u6ca1\u6709\u83b7\u53d6\u5b8c\u6210[" + xml.substring(p1) + "]");
        }
        if (!findEq) {
            throw new XmlSyntaxException("\r\nXmlUtil :getStartTag:getArgs:\u5c5e\u6027[" + name + "] \u4e4b\u540e\u8fd8\u6ca1\u6709\u7b49\u53f7");
        }
        if (!findingValue) {
            throw new XmlSyntaxException("\r\nXmlUtil :getStartTag:getArgs:\u5c5e\u6027[" + name + "] \u4e4b\u540e\u8fd8\u6ca1\u6709\u5f00\u59cb\u83b7\u53d6\u503c.");
        }
        throw new XmlSyntaxException("\r\nXmlUtil :getStartTag:getArgs:\u5c5e\u6027[" + name + "] \u83b7\u53d6\u503c\u6ca1\u6709\u5b8c\u6210[" + xml.substring(p1) + "].");
    }

    public static Element getComment(String xml, int bg) {
        return PrivateUtil.getTextNode(xml, bg, "<!--", "-->", 2);
    }

    public static Element getCDATA(String xml, int bg) {
        return PrivateUtil.getTextNode(xml, bg, "<![CDATA[", "]]>", 3);
    }

    private static Element getTextNode(String xml, int bg, String bgStr, String edStr, int elementType) {
        int startIndex = xml.indexOf(bgStr, bg);
        if (startIndex == -1) {
            return null;
        }
        int endIndex = xml.indexOf(edStr, startIndex);
        if (endIndex == -1) {
            throw new XmlSyntaxException("\r\nXmlUtil : getTextNode: [" + xml.substring(startIndex) + "] \u6ca1\u6709\u6ce8\u91ca\u7684\u7ed3\u675f\u6807\u5fd7");
        }
        Element ele = new Element();
        ele.type = elementType;
        ele.bgIndex = startIndex;
        ele.endIndex = endIndex + edStr.length() - 1;
        ele.text = xml.substring(ele.bgIndex + bgStr.length(), ele.endIndex - (edStr.length() - 1));
        return ele;
    }

    public static Element getDTD(String xml, int bg) {
        TextAnalyzer ay = TextAnalyzer.New();
        Element ele = new Element();
        ele.type = 4;
        for (int i = bg; i < xml.length(); ++i) {
            char c = xml.charAt(i);
            if (CharUtil.isBlank(c)) continue;
            if (c == '<') {
                if (StringUtil.isString((String)xml, (String)"<!DOCTYPE", (int)i)) {
                    ele.bgIndex = i;
                    break;
                }
                return null;
            }
            throw new XmlSyntaxException("\r\nXml\u672a\u5230\u6839\u8282\u70b9\u4e4b\u524d\uff0c\u4e0d\u80fd\u51fa\u73b0\u5b57\u7b26[" + c + "]\r\n" + PrivateUtil.getErrorPosInfo(xml, i) + "\r\n^^^^^^^^^^^^^^^^^^^^^^\r\n");
        }
        if (ele.bgIndex == -1) {
            return null;
        }
        Entry e = ay.getBlank(xml, ele.bgIndex + "<!DOCTYPE".length());
        if (e == null) {
            throw new XmlSyntaxException("\r\nDTD\u4e0d\u5b8c\u6574[" + xml.substring(ele.bgIndex) + "]");
        }
        if ((e = ay.getName(xml, e.getEd() + 1, new char[]{'-', '.', ':'}, new char[]{'>', '['})) == null) {
            throw new XmlSyntaxException("\r\nDTD\u4e0d\u5b8c\u6574[" + xml.substring(ele.bgIndex) + "]");
        }
        if (xml.charAt(e.getEd() + 1) == '>') {
            ele.endIndex = e.getEd() + 1;
            return ele;
        }
        if (xml.charAt(e.getEd() + 1) != '[' && (e = ay.getBlank(xml, e.getEd() + 1)).getEd() >= xml.length() - 1) {
            throw new XmlSyntaxException("\r\nDTD\u4e0d\u5b8c\u6574[" + xml.substring(ele.bgIndex) + "]");
        }
        if (xml.charAt(e.getEd() + 1) == '[') {
            int idx = xml.indexOf("]", e.getEd() + 2);
            if (idx == -1 || idx == xml.length() - 1) {
                throw new XmlSyntaxException("\r\nDTD\u4e0d\u5b8c\u6574[" + xml.substring(ele.bgIndex) + "]");
            }
            if (xml.charAt(idx + 1) == '>') {
                ele.endIndex = idx + 1;
                return ele;
            }
            e = ay.getBlank(xml, idx + 1);
            if (e == null) {
                throw new XmlSyntaxException("\r\nDTD\u4e0d\u5b8c\u6574[" + xml.substring(ele.bgIndex) + "]");
            }
            if (xml.charAt(e.getEd() + 1) == '>') {
                ele.endIndex = e.getEd() + 1;
                return ele;
            }
            throw new XmlSyntaxException("\r\nDTD[" + xml.substring(ele.bgIndex, e.getEd() + 1) + "]\u56e0\u8be5\u6709\u4e00\u4e2a\u7ed3\u675f\u6807\u8bc6>");
        }
        if (StringUtil.isString((String)xml, (String)"SYSTEM", (int)(e.getEd() + 1))) {
            if ((e = ay.getBlank(xml, e.getEd() + 1 + "SYSTEM".length())) == null) {
                throw new XmlSyntaxException("\r\nDTD\u4e0d\u5b8c\u6574[" + xml.substring(ele.bgIndex) + "]");
            }
            if ((e = ay.getXmlString(xml, e.getEd() + 1)) == null) {
                throw new XmlSyntaxException("\r\nDTD\u4e0d\u5b8c\u6574[" + xml.substring(ele.bgIndex) + "]");
            }
            if (xml.charAt(e.getEd() + 1) == '>') {
                ele.endIndex = e.getEd() + 1;
                return ele;
            }
            if ((e = ay.getBlank(xml, e.getEd() + 1)) == null) {
                throw new XmlSyntaxException("\r\nDTD\u4e0d\u5b8c\u6574[" + xml.substring(ele.bgIndex) + "]");
            }
            if (xml.charAt(e.getEd() + 1) == '>') {
                ele.endIndex = e.getEd() + 1;
                return ele;
            }
            throw new XmlSyntaxException("\r\nDTD[" + xml.substring(ele.bgIndex, e.getEd() + 1) + "]\u56e0\u8be5\u6709\u4e00\u4e2a\u7ed3\u675f\u6807\u8bc6>");
        }
        if (xml.charAt(e.getEd() + 1) == '>') {
            ele.endIndex = e.getEd() + 1;
            return ele;
        }
        throw new XmlSyntaxException("\r\nDTD[" + xml.substring(ele.bgIndex, e.getEd() + 1) + "]\u5143\u7d20\u540d\u79f0\u540e\u9762\u53ea\u80fd\u662f[\u5b57\u7b26\u6216SYSTEM\u5173\u952e\u5b57");
    }

    public static boolean isNameStartChar(char c) {
        return CharUtil.isNameStartChar(c);
    }

    public static boolean isNameChar(char c) {
        return CharUtil.isNameChar(c) || c == '-' || c == '.' || c == ':';
    }

    private static boolean isEndChar(char c, char[] endChars) {
        for (int i = 0; i < endChars.length; ++i) {
            if (c != endChars[i]) continue;
            return true;
        }
        return false;
    }

    public static String getErrorPosInfo(String xml, int pos) {
        int len = pos > 100 ? 100 : pos;
        return xml.substring(pos - len, pos);
    }
}

