/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.xml.node;

import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNodeDefine;
import com.bokesoft.yes.meta.persist.dom.xml.node.AbstractNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.CDataNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.CommentNode;
import com.bokesoft.yes.meta.persist.dom.xml.node.TagNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class XmlTree {
    private TagNode root = null;
    private List<AbstractNode> allNodeWithCommnet = new Vector<AbstractNode>();
    private HashMap<String, AbstractNode> mapNodes = new HashMap();

    public XmlTree() {
    }

    public XmlTree(TagNode root) {
        this.root = root;
    }

    public TagNode getRoot() {
        return this.root;
    }

    public void setRoot(TagNode root) {
        this.root = root;
    }

    public void addPreComment(List<AbstractNode> comments) {
        this.root.addPreComment(comments);
    }

    public void addLastComment(List<AbstractNode> comments) {
        this.root.addLastComment(comments);
    }

    public void updateMap() {
        ArrayList<AbstractNode> commentList = new ArrayList<AbstractNode>();
        this.updateMap(this.root, commentList);
    }

    private void updateMap(TagNode tagNode, List<AbstractNode> commentList) {
        if (tagNode == null) {
            return;
        }
        tagNode.addPreComment(commentList);
        this.recordNodeWithComment(commentList, tagNode);
        commentList.clear();
        if (tagNode.getPrimaryKey() != null) {
            String parentPrimaryKey = "";
            TagNode parent = tagNode.getParent();
            parentPrimaryKey = this.getParentPrimaryKey(parentPrimaryKey, parent);
            this.mapNodes.put(parentPrimaryKey + "->" + tagNode.getPrimaryKey(), tagNode);
        }
        List<AbstractNode> children = tagNode.getChildren();
        AbstractNode node = null;
        AbstractNode tmpTagNode = null;
        int size = children.size();
        for (int n = 0; n < size; ++n) {
            node = children.get(n);
            if (node instanceof TagNode) {
                this.updateMap((TagNode)node, commentList);
                tmpTagNode = node;
                continue;
            }
            if (node instanceof CommentNode) {
                commentList.add(node);
                continue;
            }
            if (!(node instanceof CDataNode)) continue;
            node.addPreComment(commentList);
            this.recordNodeWithComment(commentList, node);
            commentList.clear();
            tmpTagNode = node;
        }
        if (tmpTagNode != null) {
            tmpTagNode.addLastComment(commentList);
            this.recordNodeWithComment(commentList, tmpTagNode);
            commentList.clear();
        }
    }

    private String getParentPrimaryKey(String parentPrimaryKey, TagNode parent) {
        if (parent != null) {
            String attrKey = DefaultNodeDefine.getInstance().getPrimaryKey(parent.getTagName());
            String primaryValue = parent.getAttributes().get(attrKey);
            parentPrimaryKey = StringUtils.isEmpty((CharSequence)primaryValue) ? parentPrimaryKey.concat(this.getParentPrimaryKey(parentPrimaryKey, parent.getParent())) : parent.getPrimaryKey();
        }
        return parentPrimaryKey;
    }

    private void recordNodeWithComment(List<AbstractNode> commnetList, AbstractNode node) {
        if (commnetList.size() > 0 && !this.allNodeWithCommnet.contains(node)) {
            this.allNodeWithCommnet.add(node);
        }
    }

    public List<AbstractNode> getNodesWithComment() {
        return this.allNodeWithCommnet;
    }

    public TagNode getTagNode(String key) {
        return (TagNode)this.mapNodes.get(key);
    }

    public boolean containKey(String key) {
        return this.mapNodes.containsKey(key);
    }
}

