/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.datamigration.calculate;

import com.bokesoft.yes.common.util.ConstUtil;
import com.bokesoft.yes.meta.datamigration.calculate.MigrationDatabjectParas;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.commondef.MetaStatus;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.datamap.calculate.RefFieldMap;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceField;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceTable;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.util.MetaUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

public class MetaMigrationParas
implements Serializable {
    private Integer statusIntValue = null;
    private String srcPrimaryTableKey = "";
    private String srcMainTableKey = "";
    private MetaTable targetMetaTable;
    private ArrayList<MetaDMSourceTable> headList = new ArrayList();
    private MetaDMSourceTable primaryDMSourceTable = null;
    private ArrayList<String> parentTableList = new ArrayList();
    private TreeMap<String, RefFieldMap> refTableMap = new TreeMap();
    private MetaDataObject srcDataObject = null;
    private MetaDataObject tgtDataObject = null;
    private HashMap<String, MetaDMSourceField> fieldMap = new HashMap();
    private ArrayList<MetaColumn> negtiveDataColumnList = new ArrayList();
    private ArrayList<MetaColumn> addDeltaColumnList = new ArrayList();
    private ArrayList<MetaDMSourceField> allDMSourceFields = new ArrayList();
    private String tag = null;
    private MigrationDatabjectParas migrationDatabjectParas = null;
    private String migrationKey = null;

    public MetaMigrationParas(MetaDataMigration meta, IMetaFactory factory) throws Throwable {
        this.srcDataObject = factory.getDataObject(meta.getSrcDataObjectKey());
        this.srcMainTableKey = this.srcDataObject.getMainTableKey();
        MetaStatusCollection statusCollection = MetaUtil.getStatusCollection(factory, this.srcDataObject);
        if (statusCollection != null) {
            for (MetaStatus metaStatus : statusCollection) {
                if (!metaStatus.getKey().equalsIgnoreCase(meta.getStatusValue())) continue;
                this.statusIntValue = metaStatus.getValue();
            }
        }
        this.tgtDataObject = factory.getDataObject(meta.getTgtDataObjectKey());
        this.targetMetaTable = (MetaTable)this.tgtDataObject.getTableCollection().get(0);
        this.migrationDatabjectParas = this.tgtDataObject.getMigrationDatabjectParas(factory);
        for (MetaDMSourceTable table : meta.getSourceTableCollection()) {
            boolean checkRefField = false;
            MetaTable metaTable = this.srcDataObject.getMetaTable(table.getTableKey());
            if (table.getIsPrimary()) {
                this.srcPrimaryTableKey = table.getTableKey();
                this.primaryDMSourceTable = table;
                this.searchParentTable(this.srcPrimaryTableKey);
            } else if (metaTable.getTableMode() == 0) {
                this.headList.add(table);
            } else {
                checkRefField = true;
            }
            ArrayList<MetaDMSourceField> removeList = new ArrayList<MetaDMSourceField>();
            for (MetaDMSourceField field : table) {
                if (checkRefField) {
                    RefFieldMap rm = null;
                    String refFieldKey = field.getRefFieldKey();
                    if (refFieldKey != null && refFieldKey.length() > 0) {
                        if (rm == null) {
                            rm = new RefFieldMap(table.getTableKey());
                            this.refTableMap.put(table.getTableKey(), rm);
                        }
                        rm.add(field.getDefinition(), refFieldKey);
                    }
                }
                if (field.getTargetFieldKey() == null || field.getTargetFieldKey().length() == 0) {
                    removeList.add(field);
                    continue;
                }
                MetaColumn column = (MetaColumn)this.targetMetaTable.get(field.getTargetFieldKey());
                if (column == null) {
                    throw new MetaException(35, SimpleStringFormat.format((String)StringTable.getString(null, "", "MigrationTargetFieldMiss"), (Object[])new Object[]{field.getTargetFieldKey(), this.targetMetaTable.getKey()}));
                }
                if (column.isGroup()) {
                    field.setGroupType(column.getGroupType());
                } else {
                    this.fieldMap.put(column.getKey(), field);
                    if (field.getIsNegtive()) {
                        this.negtiveDataColumnList.add(column);
                    }
                    if (field.getOpSign() == 0) {
                        this.addDeltaColumnList.add(column);
                    }
                }
                int dataType = column.getDataType();
                field.setTargetFieldDataType(dataType);
                if (field.getType() == 2) {
                    field.setConstValue(ConstUtil.getValue((String)field.getDefinition(), (int)dataType));
                } else if (field.getType() == 0) {
                    Integer srcDataType = ((MetaColumn)metaTable.get(field.getDefinition())).getDataType();
                    if (!srcDataType.equals(dataType)) {
                        field.setNeedTypeConvert(true);
                        field.setTargetFieldDataType(dataType);
                    }
                } else {
                    field.setNeedTypeConvert(true);
                    field.setTargetFieldDataType(dataType);
                }
                field.setTableKey(table.getTableKey());
                this.allDMSourceFields.add(field);
            }
            for (MetaDMSourceField f : removeList) {
                table.remove(f.getKey());
            }
        }
        this.migrationKey = meta.getKey();
        this.tag = meta.getCaption() == null ? "" : meta.getCaption() + "(" + meta.getKey() + ")";
    }

    private void searchParentTable(String tableKey) {
        String parentKey;
        MetaTable metaTable = this.srcDataObject.getMetaTable(tableKey);
        if (metaTable != null && (parentKey = metaTable.getParentKey()) != null && parentKey.length() > 0) {
            this.parentTableList.add(parentKey);
            this.searchParentTable(parentKey);
        }
    }

    public Integer getStatusIntValue() {
        return this.statusIntValue;
    }

    public MetaTable getTargetMetaTable() {
        return this.targetMetaTable;
    }

    public String getSrcPrimaryTableKey() {
        return this.srcPrimaryTableKey;
    }

    public String getSrcMainTableKey() {
        return this.srcMainTableKey;
    }

    public ArrayList<MetaDMSourceTable> getHeadList() {
        return this.headList;
    }

    public ArrayList<String> getParentTableList() {
        return this.parentTableList;
    }

    public TreeMap<String, RefFieldMap> getRefTableMap() {
        return this.refTableMap;
    }

    public MetaDMSourceTable getPrimaryDMSourceTable() {
        return this.primaryDMSourceTable;
    }

    public ArrayList<MetaColumn> getGroupColumnList() {
        return this.migrationDatabjectParas.getGroupColumnList();
    }

    public ArrayList<MetaColumn> getDataColumnList() {
        return this.migrationDatabjectParas.getDataColumnList();
    }

    public int getPeriodGranularity() {
        return this.migrationDatabjectParas.getPeriodGranularity();
    }

    public HashMap<String, MetaDMSourceField> getFieldMap() {
        return this.fieldMap;
    }

    public MetaDataObject getTgtDataObject() {
        return this.tgtDataObject;
    }

    public ArrayList<MetaColumn> getNegtiveDataColumnList() {
        return this.negtiveDataColumnList;
    }

    public MetaColumn getPeriodColumn() {
        return this.migrationDatabjectParas.getPeriodColumn();
    }

    public ArrayList<MetaColumn> getGroupColumnWithNoPeriodList() {
        return this.migrationDatabjectParas.getGroupColumnWithNoPeriodList();
    }

    public ArrayList<MetaColumn> getAddDeltaColumnList() {
        return this.addDeltaColumnList;
    }

    public String getPeriodImpl() {
        return this.migrationDatabjectParas.getPeriodImpl();
    }

    public String getTag() {
        return this.tag;
    }

    public String getMigrationKey() {
        return this.migrationKey;
    }

    public List<MetaDMSourceField> getAllDMSourceFields() {
        return this.allDMSourceFields;
    }

    public MetaTable getSourceMainMetaTable() {
        return this.srcDataObject.getMainTable();
    }

    public MetaDataObject getSourceDataObject() {
        return this.srcDataObject;
    }

    public String getPeriodBeginColumn(MetaColumn column) {
        MetaColumn begin = this.migrationDatabjectParas.getPeriodBeginColumn(column.getKey());
        return begin.getBindingDBColumnName();
    }

    public String getPeriodEndColumn(MetaColumn column) {
        MetaColumn end = this.migrationDatabjectParas.getPeriodEndColumn(column.getKey());
        return end.getBindingDBColumnName();
    }

    public MetaColumn getDataFieldByPeriodEndField(MetaColumn column) {
        MetaColumn dataFieldColumn = this.migrationDatabjectParas.getDataFieldByPeriodEndField(column.getKey());
        return dataFieldColumn;
    }
}

