/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.form;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaRelation;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaDataObjectJSONHandler
extends AbstractJSONHandler<MetaDataObject, ISerializeContext> {
    @Override
    public void fromJSONImpl(MetaDataObject meta, JSONObject json) throws Throwable {
        JSONObject o;
        meta.setKey(json.optString("key"));
        meta.setCaption(json.optString("caption"));
        meta.setPrimaryType(Integer.valueOf(json.optInt("primaryType")));
        meta.setSecondaryType(Integer.valueOf(json.optInt("secondaryType")));
        meta.setMainTableKey(json.optString("primaryTableKey"));
        meta.setDisplayColumns(json.optString("displayFields"));
        meta.setQueryColumns(json.optString("queryFields"));
        meta.setNoPrefix(json.optString("noPrefix"));
        meta.setCustomNoPrefix(json.optString("customNoPrefix"));
        meta.setZeroPrefix(Integer.valueOf(json.optInt("zeroPrefix")));
        meta.setMigrationUpdateStrategy(Integer.valueOf(json.optInt("zeroPrefix")));
        meta.setRelateObjectKey(json.optString("relateObjectKey"));
        meta.setVersion(Integer.valueOf(json.optInt("version")));
        meta.setProjectKey(json.optString("projectKey"));
        meta.setMaintainSchema(Boolean.valueOf(json.optBoolean("maintainSchema")));
        meta.setExtend(json.optString("extend"));
        meta.setBrowserFormKey(json.optString("browserFormKey"));
        JSONArray array = json.optJSONArray("tables");
        if (array != null) {
            MetaTableCollection tableCollection = new MetaTableCollection();
            List<MetaTable> list = UIJSONHandlerUtil.unbuild(MetaTable.class, array);
            tableCollection.addAll(list);
            meta.setTableCollection(tableCollection);
            meta.setMainTable((MetaTable)tableCollection.get(meta.getMainTableKey()));
        }
        if ((o = json.optJSONObject("relation")) != null) {
            MetaRelation relation = UIJSONHandlerUtil.unbuild(MetaRelation.class, o);
            meta.setRelation(relation);
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, MetaDataObject meta, ISerializeContext hook) throws Throwable {
        MetaRelation relation;
        JSONHelper.writeToJSON((JSONObject)json, (String)"key", (Object)meta.getKey());
        JSONHelper.writeToJSON((JSONObject)json, (String)"caption", (Object)hook.getDataObjectString(meta.getKey(), meta.getCaption()));
        JSONHelper.writeToJSON((JSONObject)json, (String)"primaryType", (Object)meta.getPrimaryType());
        JSONHelper.writeToJSON((JSONObject)json, (String)"secondaryType", (Object)meta.getSecondaryType());
        JSONHelper.writeToJSON((JSONObject)json, (String)"primaryTableKey", (Object)meta.getMainTableKey());
        JSONHelper.writeToJSON((JSONObject)json, (String)"mainTableKey", (Object)meta.getMainTableKey());
        JSONHelper.writeToJSON((JSONObject)json, (String)"displayFields", (Object)meta.getDisplayColumnsStr());
        JSONHelper.writeToJSON((JSONObject)json, (String)"queryFields", (Object)meta.getQueryColumnsStr());
        JSONHelper.writeToJSON((JSONObject)json, (String)"noPrefix", (Object)meta.getNoPrefix());
        JSONHelper.writeToJSON((JSONObject)json, (String)"customNoPrefix", (Object)meta.getCustomNoPrefix());
        JSONHelper.writeToJSON((JSONObject)json, (String)"zeroPrefix", (Object)meta.getZeroPrefix());
        JSONHelper.writeToJSON((JSONObject)json, (String)"zeroPrefix", (Object)meta.getMigrationUpdateStrategy());
        JSONHelper.writeToJSON((JSONObject)json, (String)"relateObjectKey", (Object)meta.getRelateObjectKey());
        JSONHelper.writeToJSON((JSONObject)json, (String)"version", (Object)meta.getVersion());
        JSONHelper.writeToJSON((JSONObject)json, (String)"projectKey", (Object)meta.getProjectKey());
        JSONHelper.writeToJSON((JSONObject)json, (String)"maintainSchema", (Object)meta.isMaintainSchema());
        JSONHelper.writeToJSON((JSONObject)json, (String)"browserFormKey", (Object)meta.getBrowserFormKey());
        MetaTableCollection tableCollection = meta.getTableCollection();
        if (tableCollection != null) {
            JSONArray tables = new JSONArray();
            for (MetaTable metaTable : tableCollection) {
                String tableKey = metaTable.getKey();
                JSONObject table = UIJSONHandlerUtil.build((AbstractMetaObject)metaTable, hook);
                JSONArray columns = table.optJSONArray("columns");
                int size = columns.length();
                for (int i = 0; i < size; ++i) {
                    JSONObject column = columns.optJSONObject(i);
                    String columnKey = column.getString("key");
                    MetaColumn metaColumn = (MetaColumn)metaTable.get(columnKey);
                    String caption = hook.getDataObjectString(meta.getKey(), tableKey, columnKey, metaColumn.getCaption());
                    JSONHelper.writeToJSON((JSONObject)column, (String)"caption", (Object)caption);
                }
                tables.put((Object)table);
            }
            json.put("tables", (Object)tables);
        }
        if ((relation = meta.getRelation()) != null) {
            JSONObject o = UIJSONHandlerUtil.build((AbstractMetaObject)relation, hook);
            json.put("relation", (Object)o);
        }
    }

    @Override
    public MetaDataObject newInstance() {
        return new MetaDataObject();
    }
}

