/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.com.properties;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.commondef.MetaParaGroup;
import com.bokesoft.yigo.meta.commondef.MetaParaItem;
import com.bokesoft.yigo.meta.commondef.MetaStatus;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaComboFilterJSONHandler
extends AbstractJSONHandler<MetaComboFilter, DefaultSerializeContext> {
    @Override
    public void fromJSONImpl(MetaComboFilter meta, JSONObject json) throws Throwable {
        JSONObject o;
        JSONArray array;
        int sourceType;
        meta.setType(Integer.valueOf(json.optInt("type")));
        meta.setSourceType(Integer.valueOf(json.optInt("sourceType")));
        meta.setItemsDependency(json.optString("dependency"));
        String s = json.optString("formula");
        if (s != null && !s.isEmpty()) {
            MetaBaseScript script = new MetaBaseScript("FormulaItems");
            script.setContent(s);
            meta.setFormulaItems(script);
        }
        if ((sourceType = meta.getSourceType().intValue()) == 0 && (array = json.optJSONArray("items")) != null) {
            List<MetaDefaultItem> list = UIJSONHandlerUtil.unbuild(MetaDefaultItem.class, array);
            meta.clear();
            meta.addAll(0, list);
        }
        if ((o = json.optJSONObject("queryDef")) != null) {
            MetaQueryDef queryDef = UIJSONHandlerUtil.unbuild(MetaQueryDef.class, o);
            meta.setQueryDef(queryDef);
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, MetaComboFilter meta, DefaultSerializeContext hook) throws Throwable {
        MetaQueryDef queryDef;
        JSONHelper.writeToJSON((JSONObject)json, (String)"type", (Object)meta.getType());
        JSONHelper.writeToJSON((JSONObject)json, (String)"sourceType", (Object)meta.getSourceType());
        JSONHelper.writeToJSON((JSONObject)json, (String)"dependency", (Object)String.join((CharSequence)",", meta.getDependedFields()));
        MetaBaseScript formulaItems = meta.getFormulaItems();
        if (formulaItems != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"formula", (Object)formulaItems.getContent().trim());
        }
        JSONArray array = null;
        if (meta.getSourceType() == 0 && !meta.isEmpty()) {
            array = this.buildCommonItems(hook, meta);
        }
        if (array != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"items", array);
        }
        if ((queryDef = meta.getQueryDef()) != null) {
            JSONObject o = UIJSONHandlerUtil.build((AbstractMetaObject)queryDef, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"queryDef", (Object)o);
        }
        JSONHelper.writeToJSON((JSONObject)json, (String)"dependency", (Object)String.join((CharSequence)",", meta.getDependedFields()));
    }

    private JSONArray buildCommonItems(DefaultSerializeContext hook, MetaComboFilter comboFilter) throws Throwable {
        JSONArray array = new JSONArray();
        for (int i = 0; i < comboFilter.size(); ++i) {
            MetaDefaultItem metaItem = (MetaDefaultItem)comboFilter.get(i);
            JSONObject itemJSON = new JSONObject();
            JSONHelper.writeToJSON((JSONObject)itemJSON, (String)"value", (Object)metaItem.getValue());
            array.put((Object)itemJSON);
        }
        return array;
    }

    private JSONArray buildStatusItems(DefaultSerializeContext hook, MetaStatusCollection statusCollection) throws Throwable {
        JSONArray array = new JSONArray();
        Iterator it = statusCollection.iterator();
        MetaStatus metaStatus = null;
        String caption = null;
        while (it.hasNext()) {
            metaStatus = (MetaStatus)it.next();
            JSONObject itemJSON = new JSONObject();
            JSONHelper.writeToJSON((JSONObject)itemJSON, (String)"key", (Object)metaStatus.getKey());
            caption = hook.getString("Status", "", metaStatus.getKey(), metaStatus.getCaption());
            JSONHelper.writeToJSON((JSONObject)itemJSON, (String)"caption", (Object)caption);
            JSONHelper.writeToJSON((JSONObject)itemJSON, (String)"value", (int)metaStatus.getValue(), (int)Integer.MIN_VALUE);
            array.put((Object)itemJSON);
        }
        return array;
    }

    private JSONArray buildGroupItems(DefaultSerializeContext hook, MetaParaGroup metaGroup) throws Throwable {
        JSONArray array = new JSONArray();
        for (MetaParaItem metaParaItem : metaGroup) {
            JSONObject paraJSON = new JSONObject();
            JSONHelper.writeToJSON((JSONObject)paraJSON, (String)"key", (Object)metaParaItem.getKey());
            String caption = hook.getString("Paras", metaGroup.getKey(), metaParaItem.getKey(), metaParaItem.getCaption());
            JSONHelper.writeToJSON((JSONObject)paraJSON, (String)"caption", (Object)caption);
            JSONHelper.writeToJSON((JSONObject)paraJSON, (String)"value", (Object)metaParaItem.getValue());
            array.put((Object)paraJSON);
        }
        return array;
    }

    @Override
    public MetaComboFilter newInstance() {
        return new MetaComboFilter();
    }
}

