/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yes.meta.json.util.SerializeNodeUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.bpm.migration.MetaDMField;
import com.bokesoft.yigo.meta.bpm.migration.MetaDMTable;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.attachment.MetaAttachment;
import com.bokesoft.yigo.meta.bpm.process.attachment.MetaAttachmentCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMInfo;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMInfoCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimline;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlineCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaDictionary;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaExternalLink;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaMidFormula;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaParticipatorCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaQuery;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaRelation;
import com.bokesoft.yigo.meta.bpm.process.event.MetaEventCollection;
import com.bokesoft.yigo.meta.bpm.process.event.MetaEventCollectionExternalLink;
import com.bokesoft.yigo.meta.bpm.process.event.MetaEventItem;
import com.bokesoft.yigo.meta.bpm.process.expand.MetaExpand;
import com.bokesoft.yigo.meta.bpm.process.multipleform.MetaRefForm;
import com.bokesoft.yigo.meta.bpm.process.multipleform.MetaRefFormCollection;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPerm;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPermCollection;
import com.bokesoft.yigo.meta.bpm.process.perm.extend.MetaInitiatorPermCollection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaProcessJSONHandler
extends AbstractJSONHandler<MetaProcess, BPMSerializeContext> {
    @Override
    public void fromJSONImpl(MetaProcess meta, JSONObject json) throws Throwable {
        String tagName;
        JSONObject jsonObject;
        int i;
        int size;
        JSONArray array;
        meta.setKey(json.optString("key"));
        meta.setCaption(json.optString("caption"));
        meta.setIdSeed(Integer.valueOf(json.optInt("idSeed")));
        meta.setVersion(Integer.valueOf(json.optInt("version")));
        meta.setFormKey(json.optString("formKey"));
        meta.setTemplateKey(json.optString("templateKey"));
        meta.setIgnoreFormState(Boolean.valueOf(json.optBoolean("ignoreFormState")));
        meta.setQueryRetreatWorkitem(Boolean.valueOf(json.optBoolean("queryRetreatWorkitem")));
        meta.setKillInstanceTrigger(json.optString("killInstanceTrigger"));
        meta.setLockWorkitem(Integer.valueOf(json.optInt("lockWorkitem")));
        JSONObject o = json.optJSONObject("expand");
        if (o != null) {
            MetaExpand metaExpand = BPMJSONHandlerUtil.unbuild(MetaExpand.class, o);
            meta.setExpand(metaExpand);
        }
        if ((array = json.optJSONArray("swimlineCollection")) != null) {
            MetaSwimlineCollection swimlineCollection = new MetaSwimlineCollection();
            swimlineCollection.addAll(BPMJSONHandlerUtil.unbuild(MetaSwimline.class, array));
            meta.setSwimlineCollection(swimlineCollection);
        }
        if ((array = json.optJSONArray("bpmInfoCollection")) != null) {
            MetaBPMInfoCollection bpmInfoCollection = new MetaBPMInfoCollection();
            bpmInfoCollection.addAll(BPMJSONHandlerUtil.unbuild(MetaBPMInfo.class, array));
            meta.setBPMInfoCollection(bpmInfoCollection);
        }
        if ((array = json.optJSONArray("dataMigrationTable")) != null) {
            MetaDMTable dataMigrationTable = new MetaDMTable();
            dataMigrationTable.addAll(BPMJSONHandlerUtil.unbuild(MetaDMField.class, array));
            meta.setDataMigrationTable(dataMigrationTable);
        }
        if ((array = json.optJSONArray("permCollection")) != null) {
            MetaPermCollection permCollection = new MetaPermCollection();
            permCollection.addAll(0, BPMJSONHandlerUtil.unbuild(MetaPerm.class, array));
            meta.setPermCollection(permCollection);
        }
        if ((array = json.optJSONArray("initiatorPermCollection")) != null) {
            MetaInitiatorPermCollection initiatorPermCollection = new MetaInitiatorPermCollection();
            initiatorPermCollection.addAll(0, BPMJSONHandlerUtil.unbuild(MetaPerm.class, array));
            meta.setInitiatorPermCollection(initiatorPermCollection);
        }
        if ((array = json.optJSONArray("attachmentCollection")) != null) {
            MetaAttachmentCollection attachmentCollection = new MetaAttachmentCollection();
            attachmentCollection.addAll(BPMJSONHandlerUtil.unbuild(MetaAttachment.class, array));
            meta.setAttachmentCollection(attachmentCollection);
        }
        if ((array = json.optJSONArray("globalptorCollection")) != null) {
            MetaParticipatorCollection globalptorCollection = new MetaParticipatorCollection();
            size = array.length();
            for (i = 0; i < size; ++i) {
                jsonObject = array.getJSONObject(i);
                tagName = jsonObject.optString("tagName");
                if ("Dictionary".equalsIgnoreCase(tagName)) {
                    globalptorCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaDictionary.class, jsonObject));
                    continue;
                }
                if ("MidFormula".equalsIgnoreCase(tagName)) {
                    globalptorCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaMidFormula.class, jsonObject));
                    continue;
                }
                if ("Query".equalsIgnoreCase(tagName)) {
                    globalptorCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaQuery.class, jsonObject));
                    continue;
                }
                if ("Relation".equalsIgnoreCase(tagName)) {
                    globalptorCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaRelation.class, jsonObject));
                    continue;
                }
                if (!"ExternalLink".equalsIgnoreCase(tagName)) continue;
                globalptorCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaExternalLink.class, jsonObject));
            }
            meta.setGlobeptorsCollection(globalptorCollection);
        }
        if ((array = json.optJSONArray("eventCollection")) != null) {
            MetaEventCollection eventCollection = new MetaEventCollection();
            size = array.length();
            for (i = 0; i < size; ++i) {
                jsonObject = array.getJSONObject(i);
                tagName = jsonObject.optString("tagName");
                if ("EventItem".equalsIgnoreCase(tagName)) {
                    eventCollection.add((KeyPairMetaObject)BPMJSONHandlerUtil.unbuild(MetaEventItem.class, jsonObject));
                    continue;
                }
                if (!"EventCollectionExternalLink".equalsIgnoreCase(tagName)) continue;
                eventCollection.add((KeyPairMetaObject)BPMJSONHandlerUtil.unbuild(MetaEventCollectionExternalLink.class, jsonObject));
            }
            meta.setEventCollection(eventCollection);
        }
        if ((array = json.optJSONArray("refFormCollection")) != null) {
            MetaRefFormCollection refFormCollection = new MetaRefFormCollection();
            refFormCollection.addAll(BPMJSONHandlerUtil.unbuild(MetaRefForm.class, array));
            meta.setRefFormCollection(refFormCollection);
        }
        if ((array = json.optJSONArray("nodes")) != null) {
            List<MetaNode> list = SerializeNodeUtil.unbuildNodes(array);
            meta.addAll(list);
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, MetaProcess meta, BPMSerializeContext hook) throws Throwable {
        JSONArray array;
        MetaRefFormCollection refFormCollection;
        MetaEventCollection eventCollection;
        MetaParticipatorCollection globalptorCollection;
        MetaAttachmentCollection attachmentCollection;
        MetaInitiatorPermCollection initiatorPermCollection;
        MetaPermCollection permCollection;
        MetaDMTable dataMigrationTable;
        MetaBPMInfoCollection bpmInfoCollection;
        MetaSwimlineCollection swimlineCollection;
        JSONHelper.writeToJSON((JSONObject)json, (String)"tagName", (Object)meta.getTagName());
        JSONHelper.writeToJSON((JSONObject)json, (String)"key", (Object)meta.getKey());
        String caption = hook.getProcessString("BPM_Node", meta.getKey(), meta.getCaption());
        JSONHelper.writeToJSON((JSONObject)json, (String)"caption", (Object)caption);
        JSONHelper.writeToJSON((JSONObject)json, (String)"idSeed", (Object)meta.getIdSeed());
        JSONHelper.writeToJSON((JSONObject)json, (String)"version", (Object)meta.getVersion());
        JSONHelper.writeToJSON((JSONObject)json, (String)"formKey", (Object)meta.getFormKey());
        JSONHelper.writeToJSON((JSONObject)json, (String)"templateKey", (Object)meta.getTemplateKey());
        JSONHelper.writeToJSON((JSONObject)json, (String)"ignoreFormState", (Object)meta.getIgnoreFormState());
        JSONHelper.writeToJSON((JSONObject)json, (String)"queryRetreatWorkitem", (Object)meta.getQueryRetreatWorkitem());
        JSONHelper.writeToJSON((JSONObject)json, (String)"killInstanceTrigger", (Object)meta.getKillInstanceTrigger());
        JSONHelper.writeToJSON((JSONObject)json, (String)"lockWorkitem", (Object)meta.getLockWorkitem());
        MetaExpand metaExpand = meta.getExpand();
        if (metaExpand != null) {
            JSONObject o = BPMJSONHandlerUtil.build((AbstractMetaObject)metaExpand, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"expand", (Object)o);
        }
        if ((swimlineCollection = meta.getSwimlineCollection()) != null) {
            JSONArray array2 = BPMJSONHandlerUtil.buildKeyCollection(hook, (GenericKeyCollection<? extends AbstractMetaObject>)swimlineCollection);
            JSONHelper.writeToJSON((JSONObject)json, (String)"swimlineCollection", (Object)array2);
        }
        if ((bpmInfoCollection = meta.getBPMInfoCollection()) != null) {
            JSONArray array3 = BPMJSONHandlerUtil.buildKeyCollection(hook, (GenericKeyCollection<? extends AbstractMetaObject>)bpmInfoCollection);
            JSONHelper.writeToJSON((JSONObject)json, (String)"bpmInfoCollection", (Object)array3);
        }
        if ((dataMigrationTable = meta.getDataMigrationTable()) != null) {
            JSONArray array4 = BPMJSONHandlerUtil.buildKeyCollection(hook, (GenericKeyCollection<? extends AbstractMetaObject>)dataMigrationTable);
            JSONHelper.writeToJSON((JSONObject)json, (String)"dataMigrationTable", (Object)array4);
        }
        if ((permCollection = meta.getPermCollection()) != null) {
            JSONArray array5 = BPMJSONHandlerUtil.buildNoKeyCollection(hook, (GenericNoKeyCollection<? extends AbstractMetaObject>)permCollection);
            JSONHelper.writeToJSON((JSONObject)json, (String)"permCollection", (Object)array5);
        }
        if ((initiatorPermCollection = meta.getInitiatorPermCollection()) != null) {
            JSONArray array6 = BPMJSONHandlerUtil.buildNoKeyCollection(hook, (GenericNoKeyCollection<? extends AbstractMetaObject>)initiatorPermCollection);
            JSONHelper.writeToJSON((JSONObject)json, (String)"initiatorPermCollection", (Object)array6);
        }
        if ((attachmentCollection = meta.getAttachmentCollection()) != null) {
            JSONArray array7 = BPMJSONHandlerUtil.buildKeyCollection(hook, (GenericKeyCollection<? extends AbstractMetaObject>)attachmentCollection);
            JSONHelper.writeToJSON((JSONObject)json, (String)"attachmentCollection", (Object)array7);
        }
        if ((globalptorCollection = meta.getGlobeptorsCollection()) != null) {
            JSONArray array8 = BPMJSONHandlerUtil.buildNoKeyCollection(hook, (GenericNoKeyCollection<? extends AbstractMetaObject>)globalptorCollection);
            JSONHelper.writeToJSON((JSONObject)json, (String)"globalptorCollection", (Object)array8);
        }
        if ((eventCollection = meta.getEventCollection()) != null) {
            JSONArray array9 = BPMJSONHandlerUtil.buildKeyCollection(hook, (GenericKeyCollection<? extends AbstractMetaObject>)eventCollection);
            JSONHelper.writeToJSON((JSONObject)json, (String)"eventCollection", (Object)array9);
        }
        if ((refFormCollection = meta.getRefFormCollection()) != null) {
            array = BPMJSONHandlerUtil.buildKeyCollection(hook, (GenericKeyCollection<? extends AbstractMetaObject>)refFormCollection);
            JSONHelper.writeToJSON((JSONObject)json, (String)"refFormCollection", (Object)array);
        }
        array = BPMJSONHandlerUtil.buildKeyCollection(hook, (GenericKeyCollection<? extends AbstractMetaObject>)meta);
        JSONHelper.writeToJSON((JSONObject)json, (String)"nodes", (Object)array);
    }

    @Override
    public MetaProcess newInstance() {
        return new MetaProcess();
    }
}

