/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.com.properties;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.com.properties.BasePropertiesJSONHandler;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.common.def.ComboBoxTextShowType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.commondef.MetaParaGroup;
import com.bokesoft.yigo.meta.commondef.MetaParaItem;
import com.bokesoft.yigo.meta.commondef.MetaStatus;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckListBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaListBoxItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaQueryDef;
import com.bokesoft.yigo.meta.util.MetaUtil;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaCheckListBoxPropertiesJSONHandler
extends BasePropertiesJSONHandler<MetaCheckListBoxProperties> {
    @Override
    public void fromJSONImpl(MetaCheckListBoxProperties meta, JSONObject json) throws Throwable {
        JSONObject o;
        JSONArray array;
        int sourceType;
        meta.setItemsDependency(json.optString("dependency"));
        meta.setGroupKey(json.optString("groupKey"));
        meta.setGlobalItems(json.optString("globalItems"));
        meta.setCache(Boolean.valueOf(json.optBoolean("cache")));
        meta.setPromptText(json.optString("promptText"));
        meta.setStyle(Integer.valueOf(json.optInt("style")));
        meta.setEditType(Integer.valueOf(json.optInt("editType")));
        meta.setColumnCount(Integer.valueOf(json.optInt("columnCount")));
        meta.setPopAnim(json.optString("popAnim"));
        meta.setSourceType(Integer.valueOf(json.optInt("sourceType")));
        meta.setGlobalItems(json.optString("globalItems"));
        meta.setSourceType(Integer.valueOf(json.optInt("sourceType")));
        meta.setTextShowType(Integer.valueOf(ComboBoxTextShowType.parse((String)json.getString("textShowType"))));
        String s = json.optString("formula");
        if (s != null && !s.isEmpty()) {
            MetaBaseScript script = new MetaBaseScript("FormulaItems");
            script.setContent(s);
            meta.setFormulaItems(script);
        }
        if (((sourceType = meta.getSourceType().intValue()) == 0 || sourceType == 3 || sourceType == 4) && (array = json.optJSONArray("items")) != null) {
            MetaListBoxItemCollection metaItems = new MetaListBoxItemCollection();
            List<MetaDefaultItem> list = UIJSONHandlerUtil.unbuild(MetaDefaultItem.class, array);
            metaItems.addAll(0, list);
            meta.setItems(metaItems);
        }
        if ((o = json.optJSONObject("queryDef")) != null) {
            MetaQueryDef queryDef = UIJSONHandlerUtil.unbuild(MetaQueryDef.class, o);
            meta.setQueryDef(queryDef);
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, MetaCheckListBoxProperties meta, DefaultSerializeContext hook, String key) throws Throwable {
        MetaQueryDef queryDef;
        JSONHelper.writeToJSON((JSONObject)json, (String)"dependency", (Object)String.join((CharSequence)",", meta.getDependedFields()));
        JSONHelper.writeToJSON((JSONObject)json, (String)"groupKey", (Object)meta.getGroupKey());
        JSONHelper.writeToJSON((JSONObject)json, (String)"globalItems", (Object)meta.getGlobalItems());
        JSONHelper.writeToJSON((JSONObject)json, (String)"cache", (boolean)meta.getCache(), (boolean)false);
        String promptText = hook.getString("Prompt", "", key, meta.getPromptText());
        JSONHelper.writeToJSON((JSONObject)json, (String)"promptText", (Object)promptText);
        JSONHelper.writeToJSON((JSONObject)json, (String)"style", (Object)meta.getStyle());
        JSONHelper.writeToJSON((JSONObject)json, (String)"editType", (Object)meta.getEditType());
        JSONHelper.writeToJSON((JSONObject)json, (String)"columnCount", (Object)meta.getColumnCount());
        JSONHelper.writeToJSON((JSONObject)json, (String)"popAnim", (Object)meta.getPopAnim());
        JSONHelper.writeToJSON((JSONObject)json, (String)"sourceType", (Object)meta.getSourceType());
        JSONHelper.writeToJSON((JSONObject)json, (String)"globalItems", (Object)meta.getGlobalItems());
        JSONHelper.writeToJSON((JSONObject)json, (String)"textShowType", (Object)ComboBoxTextShowType.format((Integer)meta.getTextShowType()));
        JSONHelper.writeToJSON((JSONObject)json, (String)"textShowFormat", (Object)meta.getTextShowFormat());
        MetaBaseScript formulaItems = meta.getFormulaItems();
        if (formulaItems != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"formula", (Object)formulaItems.getContent().trim());
        }
        JSONArray array = null;
        switch (meta.getSourceType()) {
            case 0: {
                MetaListBoxItemCollection metaItems = meta.getItems();
                if (metaItems == null) break;
                array = this.buildCommonItems(key, hook, metaItems);
                break;
            }
            case 3: {
                MetaStatusCollection statusCollection = MetaUtil.getStatusCollection((IMetaFactory)hook.getVE().getMetaFactory(), (MetaForm)hook.getMetaForm());
                if (statusCollection == null) break;
                array = this.buildStatusItems(hook, statusCollection);
                break;
            }
            case 4: {
                MetaParaGroup metaParaGroup = MetaUtil.getParaGroup((IMetaFactory)hook.getVE().getMetaFactory(), (MetaForm)hook.getMetaForm(), (String)meta.getGroupKey());
                if (metaParaGroup == null) break;
                array = this.buildGroupItems(hook, metaParaGroup);
            }
        }
        if (array != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"items", array);
        }
        if ((queryDef = meta.getQueryDef()) != null) {
            JSONObject o = UIJSONHandlerUtil.build((AbstractMetaObject)queryDef, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"queryDef", (Object)o);
        }
        JSONHelper.writeToJSON((JSONObject)json, (String)"dependency", (Object)String.join((CharSequence)",", meta.getDependedFields()));
    }

    private JSONArray buildCommonItems(String key, DefaultSerializeContext hook, MetaListBoxItemCollection metaItems) throws Throwable {
        JSONArray array = new JSONArray();
        for (MetaDefaultItem metaItem : metaItems) {
            JSONObject itemJSON = new JSONObject();
            JSONHelper.writeToJSON((JSONObject)itemJSON, (String)"key", (Object)metaItem.getKey());
            String text = hook.getString("Items", key, "Item-" + metaItem.getKey(), metaItem.getCaption());
            JSONHelper.writeToJSON((JSONObject)itemJSON, (String)"caption", (Object)text);
            JSONHelper.writeToJSON((JSONObject)itemJSON, (String)"value", (Object)metaItem.getValue());
            array.put((Object)itemJSON);
        }
        return array;
    }

    private JSONArray buildStatusItems(DefaultSerializeContext hook, MetaStatusCollection statusCollection) throws Throwable {
        JSONArray array = new JSONArray();
        Iterator it = statusCollection.iterator();
        MetaStatus metaStatus = null;
        String caption = null;
        while (it.hasNext()) {
            metaStatus = (MetaStatus)it.next();
            JSONObject itemJSON = new JSONObject();
            JSONHelper.writeToJSON((JSONObject)itemJSON, (String)"key", (Object)metaStatus.getKey());
            caption = hook.getString("Status", "", metaStatus.getKey(), metaStatus.getCaption());
            JSONHelper.writeToJSON((JSONObject)itemJSON, (String)"caption", (Object)caption);
            JSONHelper.writeToJSON((JSONObject)itemJSON, (String)"value", (Object)metaStatus.getValue());
            array.put((Object)itemJSON);
        }
        return array;
    }

    private JSONArray buildGroupItems(DefaultSerializeContext hook, MetaParaGroup metaGroup) throws Throwable {
        JSONArray array = new JSONArray();
        for (MetaParaItem metaParaItem : metaGroup) {
            JSONObject paraJSON = new JSONObject();
            JSONHelper.writeToJSON((JSONObject)paraJSON, (String)"key", (Object)metaParaItem.getKey());
            String caption = hook.getString("Paras", metaGroup.getKey(), metaParaItem.getKey(), metaParaItem.getCaption());
            JSONHelper.writeToJSON((JSONObject)paraJSON, (String)"caption", (Object)caption);
            JSONHelper.writeToJSON((JSONObject)paraJSON, (String)"value", (Object)metaParaItem.getValue());
            array.put((Object)paraJSON);
        }
        return array;
    }

    @Override
    public MetaCheckListBoxProperties newInstance() {
        return new MetaCheckListBoxProperties();
    }
}

