/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.com.comp;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.MetaCarousel;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCarouselItemCollection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaCarouselJSONHandler
extends BaseComponentJSONHandler<MetaCarousel> {
    @Override
    public void toJSONImpl(JSONObject json, MetaCarousel meta, DefaultSerializeContext hook) throws Throwable {
        super.toJSONImpl(json, meta, hook);
        JSONHelper.writeToJSON((JSONObject)json, (String)"sourceType", (Object)meta.getSourceType());
        if (meta.isShowDots() != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"showDots", (Object)meta.isShowDots());
        }
        if (meta.isAutoplay() != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"autoplay", (Object)meta.isAutoplay());
        }
        JSONHelper.writeToJSON((JSONObject)json, (String)"autoplayInterval", (Object)meta.getAutoplayInterval());
        JSONHelper.writeToJSON((JSONObject)json, (String)"infinite", (Object)meta.isInfinite());
        switch (meta.getSourceType()) {
            case 0: {
                MetaCarouselItemCollection metaItems = meta.getItems();
                if (metaItems == null) break;
                JSONArray array = this.buildCommonItems(hook, metaItems);
                JSONHelper.writeToJSON((JSONObject)json, (String)"items", (Object)array);
                break;
            }
            case 1: {
                MetaBaseScript formulaItems = meta.getFormulaItems();
                if (formulaItems == null) break;
                JSONHelper.writeToJSON((JSONObject)json, (String)"formulaItems", (Object)formulaItems.getContent().trim());
            }
        }
        MetaBaseScript onClick = meta.getOnClick();
        if (onClick != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"onClick", (Object)onClick.getContent().trim());
        }
    }

    private JSONArray buildCommonItems(ISerializeContext hook, MetaCarouselItemCollection metaItems) throws Throwable {
        JSONArray array = new JSONArray();
        for (MetaDefaultItem metaItem : metaItems) {
            JSONObject itemJSON = new JSONObject();
            JSONHelper.writeToJSON((JSONObject)itemJSON, (String)"key", (Object)metaItem.getKey());
            JSONHelper.writeToJSON((JSONObject)itemJSON, (String)"caption", (Object)metaItem.getCaption());
            JSONHelper.writeToJSON((JSONObject)itemJSON, (String)"value", (Object)metaItem.getValue());
            array.put((Object)itemJSON);
        }
        return array;
    }

    @Override
    public void fromJSONImpl(MetaCarousel meta, JSONObject json) throws Throwable {
        MetaBaseScript script;
        String s;
        super.fromJSONImpl(meta, json);
        meta.setSourceType(Integer.valueOf(json.optInt("sourceType")));
        meta.setShowDots(Boolean.valueOf(json.optBoolean("showDots")));
        meta.setAutoplay(Boolean.valueOf(json.optBoolean("autoplay")));
        meta.setAutoplayInterval(Integer.valueOf(json.optInt("autoplayInterval", -1)));
        meta.setInfinite(Boolean.valueOf(json.optBoolean("infinite")));
        int sourceType = meta.getSourceType();
        if (sourceType == 0) {
            JSONArray array = json.optJSONArray("items");
            if (array != null) {
                MetaCarouselItemCollection metaItems = new MetaCarouselItemCollection();
                List<MetaDefaultItem> list = UIJSONHandlerUtil.unbuild(MetaDefaultItem.class, array);
                metaItems.addAll(0, list);
                meta.setItems(metaItems);
            }
        } else if (sourceType == 1 && (s = json.optString("formulaItems")) != null && !s.isEmpty()) {
            script = new MetaBaseScript("FormulaItems");
            script.setContent(s);
            meta.setFormulaItems(script);
        }
        s = json.optString("onClick");
        if (s != null && !s.isEmpty()) {
            script = new MetaBaseScript("OnClick");
            script.setContent(s);
            meta.setOnClick(script);
        }
    }

    @Override
    public MetaCarousel newInstance() {
        return new MetaCarousel();
    }
}

