/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.com.comp;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.chart.MetaCategory;
import com.bokesoft.yigo.meta.form.component.chart.MetaChart;
import com.bokesoft.yigo.meta.form.component.chart.MetaChartDataSource;
import com.bokesoft.yigo.meta.form.component.chart.MetaChartTemplate;
import com.bokesoft.yigo.meta.form.component.chart.MetaSeries;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaChartJSONHandler
extends BaseComponentJSONHandler<MetaChart> {
    @Override
    public void fromJSONImpl(MetaChart meta, JSONObject json) throws Throwable {
        String s;
        super.fromJSONImpl(meta, json);
        JSONObject o = json.optJSONObject("dataSource");
        if (o != null) {
            MetaChartDataSource dataSource = this.unbuildDataSource(o);
            meta.setDataSource(dataSource);
        }
        if ((s = json.optString("onClick")) != null && !s.isEmpty()) {
            MetaBaseScript script = new MetaBaseScript("OnClick");
            script.setContent(s);
            meta.setOnClick(script);
        }
        meta.setChartType(json.optInt("chartType"));
        meta.setSourceType(json.optInt("sourceType"));
        meta.setTitle(json.optString("title"));
        meta.setSeriesInRow(json.optBoolean("seriesInRow"));
        meta.setSeriesAxisTitle(json.optString("seriesAxisTitle"));
        meta.setCategoryAxisTitle(json.optString("categoryAxisTitle"));
        meta.setShowValue(json.optBoolean("showValues"));
        meta.setFill(json.optBoolean("fill"));
        meta.setHasAnimation(json.optBoolean("hasAnimation"));
    }

    @Override
    public void toJSONImpl(JSONObject json, MetaChart meta, DefaultSerializeContext hook) throws Throwable {
        MetaBaseScript onClick;
        super.toJSONImpl(json, meta, hook);
        MetaChartDataSource dataSource = meta.getDataSource();
        if (dataSource != null) {
            JSONObject o = this.buildDataSource(dataSource, meta.getKey(), hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"dataSource", (Object)o);
        }
        if ((onClick = meta.getOnClick()) != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"onClick", (Object)onClick.getContent().trim());
        }
        JSONHelper.writeToJSON((JSONObject)json, (String)"chartType", (Object)meta.getChartType());
        JSONHelper.writeToJSON((JSONObject)json, (String)"sourceType", (Object)meta.getSourceType());
        JSONHelper.writeToJSON((JSONObject)json, (String)"title", (Object)hook.getString("Chart", meta.getKey(), "Title", meta.getTitle()));
        JSONHelper.writeToJSON((JSONObject)json, (String)"seriesInRow", (Object)meta.getSeriesInRow());
        JSONHelper.writeToJSON((JSONObject)json, (String)"seriesAxisTitle", (Object)hook.getString("Chart", meta.getKey(), "SeriesAxisTitle", meta.getSeriesAxisTitle()));
        JSONHelper.writeToJSON((JSONObject)json, (String)"categoryAxisTitle", (Object)hook.getString("Chart", meta.getKey(), "CategoryAxisTitle", meta.getCategoryAxisTitle()));
        JSONHelper.writeToJSON((JSONObject)json, (String)"showValues", (Object)meta.isShowValue());
        JSONHelper.writeToJSON((JSONObject)json, (String)"fill", (Object)meta.isFill());
        JSONHelper.writeToJSON((JSONObject)json, (String)"hasAnimation", (Object)meta.isHasAnimation());
        MetaChartTemplate chartTemplate = meta.getChartTemplate();
        if (chartTemplate != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"chartTemplate", (Object)chartTemplate.toJSON());
        }
    }

    private JSONObject buildDataSource(MetaChartDataSource meta, String key, DefaultSerializeContext hook) throws Throwable {
        JSONObject json = new JSONObject();
        MetaCategory category = meta.getCategory();
        if (category != null) {
            JSONObject categoryJSON = new JSONObject();
            categoryJSON.put("dataKey", (Object)category.getDataKey());
            json.put("category", (Object)categoryJSON);
        }
        List list = meta.getSeriesArray();
        JSONArray array = new JSONArray();
        for (MetaSeries series : list) {
            JSONObject seriesJSON = new JSONObject();
            seriesJSON.put("splitDataKey", (Object)series.getSplitDataKey());
            seriesJSON.put("dataKey", (Object)series.getDataKey());
            seriesJSON.put("title", (Object)hook.getString("Chart", key, "Series-" + series.getDataKey(), series.getTitle()));
            array.put((Object)seriesJSON);
        }
        JSONHelper.writeToJSON((JSONObject)json, (String)"series", (Object)array);
        JSONHelper.writeToJSON((JSONObject)json, (String)"bindingKey", (Object)meta.getBindingKey());
        return json;
    }

    private MetaChartDataSource unbuildDataSource(JSONObject json) {
        MetaChartDataSource dataSource = new MetaChartDataSource();
        JSONObject o = json.optJSONObject("category");
        if (o != null) {
            MetaCategory category = new MetaCategory();
            category.setDataKey(o.optString("dataKey"));
            dataSource.setCategory(category);
        }
        ArrayList<MetaSeries> seriesArray = new ArrayList<MetaSeries>();
        JSONArray array = json.optJSONArray("series");
        int size = array.length();
        for (int i = 0; i < size; ++i) {
            JSONObject seriesObj = array.getJSONObject(i);
            MetaSeries series = new MetaSeries();
            series.setSplitDataKey(seriesObj.optString("splitDataKey"));
            series.setDataKey(seriesObj.optString("dataKey"));
            series.setTitle(seriesObj.optString("title"));
            seriesArray.add(series);
        }
        dataSource.setSeriesArray(seriesArray);
        dataSource.setBindingKey(json.optString("bindingKey"));
        return dataSource;
    }

    @Override
    public MetaChart newInstance() {
        return new MetaChart();
    }
}

