package com.bokesoft.yes.meta.json.panel.gridpanel;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDef;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;

public class MetaColumnDefCollectionJSONHandler extends AbstractJSONHandler<MetaColumnDefCollection,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaColumnDefCollection meta,
			DefaultSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.GRIDLAYOUTPANEL_COLUMNGAP, meta.getColumnGap());
		JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, meta);
		json.put(JSONConstants.COMMON_ITEMS, array);
	}

	@Override
	public void fromJSONImpl(MetaColumnDefCollection meta, JSONObject json) throws Throwable {
		meta.setColumnGap(json.optInt(JSONConstants.GRIDLAYOUTPANEL_COLUMNGAP));
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if( array != null ) {
			List<MetaColumnDef> list = UIJSONHandlerUtil.unbuild(MetaColumnDef.class, array);
			meta.addAll(0, list);
		}
	}

	@Override
	public MetaColumnDefCollection newInstance() {
		return new MetaColumnDefCollection();
	}
}
