package com.bokesoft.yes.meta.json.layout;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDef;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSpan;
import com.bokesoft.yigo.meta.solution.MetaLang;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaComponentLayoutJSONHandler;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaGridLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutItem;

public class MetaGridLayoutJSONHandler extends MetaComponentLayoutJSONHandler {

	@Override
	public void toJSONImpl(JSONObject json,MetaComponentLayout<? extends MetaLayoutItem> meta,
						   DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);

		MetaGridLayout layout = (MetaGridLayout)meta;
		MetaRowDefCollection rowDefCollection = layout.getRowDefCollection();
		if (rowDefCollection != null) {
			JSONObject o = UIJSONHandlerUtil.build(rowDefCollection,hook);
			JSONHelper.writeToJSON(json, JSONConstants.LAYOUT_ROWCOLLECTION, o);
		}

		MetaColumnDefCollection columnDefCollection = layout.getColumnDefCollection();
		if (columnDefCollection != null) {
			String locale = hook.getVE().getEnv().getLocale();
			MetaColumnDefCollection cloneColumnDef = (MetaColumnDefCollection) columnDefCollection.clone();
			if (!(JSONConstants.ZH_CN).equals(locale)) {
				int xIndex = 0;
				for (MetaColumnDef metaColumnDef : cloneColumnDef.getList()) {
					DefSize width = metaColumnDef.getWidth();
					if (!StringUtil.isBlankOrNull(metaColumnDef.getZhCHT_Width()) && (JSONConstants.ZH_CHT).equals(locale)){
						width = metaColumnDef.getZhCHT_Width();
					} else if (!StringUtil.isBlankOrNull(metaColumnDef.getEnUS_Width()) && (JSONConstants.EN_US).equals(locale)){
						width = metaColumnDef.getEnUS_Width();
					} else if (!StringUtil.isBlankOrNull(metaColumnDef.getRuRU_Width()) && (JSONConstants.RU_RU).equals(locale)){
						width = metaColumnDef.getRuRU_Width();
					} else if (!StringUtil.isBlankOrNull(metaColumnDef.getJaJP_Width()) && (JSONConstants.JA_JP).equals(locale)){
						width = metaColumnDef.getJaJP_Width();
					} else if (!StringUtil.isBlankOrNull(metaColumnDef.getFrFR_Width()) && (JSONConstants.FR_FR).equals(locale)){
						width = metaColumnDef.getFrFR_Width();
					} else if (!StringUtil.isBlankOrNull(metaColumnDef.getEsES_Width()) && (JSONConstants.ES_ES).equals(locale)){
						width = metaColumnDef.getEsES_Width();
					} else if (!StringUtil.isBlankOrNull(metaColumnDef.getPtPT_Width()) && (JSONConstants.PT_PT).equals(locale)){
						width = metaColumnDef.getPtPT_Width();
					} else if (!StringUtil.isBlankOrNull(metaColumnDef.getDeDE_Width()) && (JSONConstants.DE_DE).equals(locale)){
						width = metaColumnDef.getDeDE_Width();
					} else if (!StringUtil.isBlankOrNull(metaColumnDef.getArAE_Width()) && (JSONConstants.AR_AE).equals(locale)){
						width = metaColumnDef.getArAE_Width();
					} else {
						int sizeType = width.getSizeType();
						for (MetaLayoutSpan item : layout.items()) {
							int size = width.getSize();
							int itemX = item.getX();
							if (xIndex == itemX && DefSize.Ratio != sizeType) {
								MetaComponent metaComponent = hook.getMetaForm().getComponentMap().get(item.getKey());
								if (ControlType.LABEL == metaComponent.getControlType()) {
									MetaLang metaLang = MetaFactory.getGlobalInstance().getSolution().getLangConfig().get(locale);
									if( metaLang != null ) {
										float widthMultiple = Float.parseFloat(metaLang.getWidthMultiple());
										size = (int) (size * widthMultiple);
										width = new DefSize(sizeType, size);
										break;
									}
								}
							}
						}
					}
					metaColumnDef.setWidth(width);
					xIndex++;
				}
			}
			JSONObject o = UIJSONHandlerUtil.build(cloneColumnDef, hook);
//			JSONObject o = UIJSONHandlerUtil.build(columnDefCollection,hook);
			JSONHelper.writeToJSON(json, JSONConstants.LAYOUT_COLUMNCOLLECTION, o);
		}
	}

	@Override
	public void fromJSONImpl(MetaComponentLayout<? extends MetaLayoutItem> meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);

		MetaGridLayout layout = (MetaGridLayout)meta;
		JSONObject o = json.optJSONObject(JSONConstants.LAYOUT_ROWCOLLECTION);
		if( o != null ) {
			MetaRowDefCollection rowDefCollection = UIJSONHandlerUtil.unbuild(MetaRowDefCollection.class, o);
			layout.setRowDefCollection(rowDefCollection);
		}

		o = json.optJSONObject(JSONConstants.LAYOUT_COLUMNCOLLECTION);
		if( o != null ) {
			MetaColumnDefCollection columnDefCollection = UIJSONHandlerUtil.unbuild(MetaColumnDefCollection.class, o);
			layout.setColumnDefCollection(columnDefCollection);
		}
	}

	@Override
	public MetaComponentLayout<? extends MetaLayoutItem> newInstance() {
		return new MetaGridLayout();
	}
}
