package com.bokesoft.yes.meta.json.form;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.MetaNavigationBar;
import com.bokesoft.yigo.meta.form.MetaNavigationBarItem;
import com.bokesoft.yigo.meta.form.MetaNavigationBarLeftButton;
import com.bokesoft.yigo.meta.form.MetaNavigationBarRightButton;

public class MetaNavigationBarJSONHandler extends AbstractJSONHandler<MetaNavigationBar,DefaultSerializeContext>{
	
	@Override
	public void fromJSONImpl(MetaNavigationBar meta, JSONObject json) throws Throwable {
		meta.setTitle(json.optString(JSONConstants.NAVIGATION_TITLE));
		meta.setBackColor(json.optString(JSONConstants.NAVIGATION_BACKCOLOR));
		meta.setForeColor(json.optString(JSONConstants.NAVIGATION_FORECOLOR));
		meta.setBackImage(json.optString(JSONConstants.NAVIGATION_BACKIMAGE));
		meta.setHasLeftButton(json.optString(JSONConstants.NAVIGATION_HASLEFTBUTTON));
		meta.setHasRightButton(json.optString(JSONConstants.NAVIGATION_HASRIGHTBUTTON));
		
		String s = json.optString(JSONConstants.NAVIGATION_ELEVATION);
		if (s != null && !s.isEmpty()) {
			meta.setElevation(Integer.parseInt(s));
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.NAVIGATIONBAR_LEFTBUTTON);
		if( o != null ) {
			MetaNavigationBarLeftButton leftButton = UIJSONHandlerUtil.unbuild(MetaNavigationBarLeftButton.class, o);
			meta.setLeftButton(leftButton);
		}
		
		o = json.optJSONObject(JSONConstants.NAVIGATIONBAR_RIGHTBUTTON);
		if( o != null ) {
			MetaNavigationBarRightButton rightButton = UIJSONHandlerUtil.unbuild(MetaNavigationBarRightButton.class, o);
			meta.setRightButton(rightButton);
		}
		
		JSONArray array = json.optJSONArray(JSONConstants.NAVIGATION_ITEMS);
		if( array != null ) {
			List<MetaNavigationBarItem> list = UIJSONHandlerUtil.unbuild(MetaNavigationBarItem.class, array);
			meta.addAll(list);
		}
	}

	@Override
	public void toJSONImpl(JSONObject json, MetaNavigationBar meta, DefaultSerializeContext hook)
			throws Throwable {
		
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATION_TITLE, meta.getTitle());
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATION_BACKCOLOR, meta.getBackColor());
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATION_FORECOLOR, meta.getForeColor());
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATION_BACKIMAGE, meta.getBackImage());
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATION_HASLEFTBUTTON, meta.getHasLeftButton());
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATION_HASRIGHTBUTTON, meta.getHasRightButton());
		
		Integer i = meta.getElevation();
		if( i != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.NAVIGATION_ELEVATION, i);			
		}
	
		MetaNavigationBarLeftButton leftButton  = meta.getLeftButton();
		if( leftButton != null ) {
			JSONObject o = UIJSONHandlerUtil.build(leftButton,hook);
			JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONBAR_LEFTBUTTON, o);
		}
		MetaNavigationBarRightButton rightButton = meta.getRightButton();
		if( rightButton != null ) {
			JSONObject o = UIJSONHandlerUtil.build(rightButton,hook);
			JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONBAR_RIGHTBUTTON, o);
		}
		
		JSONArray items = UIJSONHandlerUtil.buildKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATION_ITEMS, items);
	}

	@Override
	public MetaNavigationBar newInstance() {
		return new MetaNavigationBar();
	}
}
