package com.bokesoft.yes.meta.json.form;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yigo.meta.common.MetaMacro;

public class MetaMacroJSONHandler extends AbstractJSONHandler<MetaMacro,ISerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaMacro meta, ISerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.MACROMAP_ARGS, meta.getArgsList());
		JSONHelper.writeToJSON(json, JSONConstants.SCRIPT_CONTENT, meta.getContent().trim());
	}

	@Override
	public void fromJSONImpl(MetaMacro meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		JSONArray args = json.optJSONArray(JSONConstants.MACROMAP_ARGS);
		if(args != null && args.length() > 0) {
			int len = args.length();
			String str = "";
			String s = null;
			for(int i = 0 ; i < len ; i ++) {
				s = args.optString(i);
				if(s != null && !s.isEmpty()) {
					str += ","+s;
				}
			}	
			if(str.length() > 0) {
				str = str.substring(1);
				meta.setArgs(str);
			}
		}
		meta.setContent(json.optString(JSONConstants.SCRIPT_CONTENT));
	}

	@Override
	public MetaMacro newInstance() {
		return new MetaMacro();
	}
}
