package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.common.MetaKeyHandler;

public class MetaKeyHandlerJSONHandler extends MetaBaseScriptJSONHandler<MetaKeyHandler,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaKeyHandler meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DESCRIPTION, meta.getDescription());
	}
	
	@Override
	public void fromJSONImpl(MetaKeyHandler meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setDescription(json.optString(JSONConstants.COMMON_DESCRIPTION));
	}
	
	@Override
	public MetaKeyHandler newInstance() {
		return new MetaKeyHandler();
	}
}
