package com.bokesoft.yes.meta.json.enhance;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.common.MetaPara;
import com.bokesoft.yigo.meta.enhance.MetaFunction;

public class MetaFunctionJSONHandler extends AbstractJSONHandler<MetaFunction,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaFunction meta, SolutionSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DESCRIPTION, meta.getDescription());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_PROVIDER, meta.getProvider());
		
		JSONArray paras = UIJSONHandlerUtil.buildKeyWithKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.FUN_PARAS, paras);
	}

	@Override
	public MetaFunction newInstance() {
		return new MetaFunction();
	}

	@Override
	public void fromJSONImpl(MetaFunction meta, JSONObject json) throws Throwable {
		meta.setDescription(json.optString(JSONConstants.COMMON_DESCRIPTION));
		meta.setProvider(json.optString(JSONConstants.COMMON_PROVIDER));
		
		JSONArray array = json.optJSONArray(JSONConstants.FUN_PARAS);
		if( array != null ) {
			meta.addAll(UIJSONHandlerUtil.unbuild(MetaPara.class, array));
		}
	}

}
