package com.bokesoft.yes.meta.json.enhance;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.enhance.MetaExtReportFunction;
import com.bokesoft.yigo.meta.enhance.MetaExtUIFunction;
import com.bokesoft.yigo.meta.enhance.MetaFunction;
import com.bokesoft.yigo.meta.enhance.MetaUIFunction;

public class MetaEnhanceJSONHandler extends AbstractJSONHandler<MetaEnhance,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaEnhance meta, SolutionSerializeContext hook)
			throws Throwable {
		MetaExtUIFunction uiFunction = meta.getMetaExtUIFunction();
		if( uiFunction != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, uiFunction);
			JSONHelper.writeToJSON(json, JSONConstants.ENHANCE_EXTFUN, array);
		}
		MetaExtReportFunction reportFunction = meta.getExtReportFunction();
		if( reportFunction != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, reportFunction);
			JSONHelper.writeToJSON(json, JSONConstants.ENHANCE_EXTREPORTFUN, array);
		}
	}

	@Override
	public MetaEnhance newInstance() {
		return new MetaEnhance();
	}

	@Override
	public void fromJSONImpl(MetaEnhance meta, JSONObject json) throws Throwable {
		JSONArray array = json.optJSONArray(JSONConstants.ENHANCE_EXTFUN);
		if( array != null ) {
			MetaExtUIFunction uiFunction = new MetaExtUIFunction();
			uiFunction.addAll(UIJSONHandlerUtil.unbuild(MetaUIFunction.class, array));
			meta.setMetaExtUIFunction(uiFunction);
		}
		array = json.optJSONArray(JSONConstants.ENHANCE_EXTREPORTFUN);
		if( array != null ) {
			MetaExtReportFunction reportFunction = new MetaExtReportFunction();
			reportFunction.addAll(UIJSONHandlerUtil.unbuild(MetaFunction.class, array));
			meta.setExtReportFunction(reportFunction);
		}
	}

}
