package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaScoreBarProperties;

public class MetaScoreBarPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaScoreBarProperties>{
	
	@Override
	public void toJSONImpl(JSONObject json, MetaScoreBarProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.SCOREBAR_COUNT, meta.getCount());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ICON, meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.SCOREBAR_SELECTICON, meta.getSelectIcon());
		JSONHelper.writeToJSON(json, JSONConstants.SCOREBAR_SUPPORTHALF, meta.isSupportHalf());
	}

	@Override
	public void fromJSONImpl(MetaScoreBarProperties meta, JSONObject json) throws Throwable {
		meta.setCount(json.optInt(JSONConstants.SCOREBAR_COUNT));
		meta.setIcon(json.optString(JSONConstants.COMMON_ICON));
		meta.setSelectIcon(json.optString(JSONConstants.SCOREBAR_SELECTICON));
		meta.setSupportHalf(json.optBoolean(JSONConstants.SCOREBAR_SUPPORTHALF));
	}

	@Override
	public MetaScoreBarProperties newInstance() {
		return new MetaScoreBarProperties();
	}

}
