package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberInfoEditorProperties;

public class MetaNumberInfoEditorPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaNumberInfoEditorProperties>{
	
	@Override
	public void toJSONImpl(JSONObject json, MetaNumberInfoEditorProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.NUMBERINFOEDITOR_FORMAT, meta.getEditorFormat());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_IMEOPTIONS, meta.getImeOptions());
		JSONHelper.writeToJSON(json, JSONConstants.NUMBERINFOEDITOR_DISABLEKEYBOARD, meta.isDisableKeyboard());
		MetaBaseScript onFocus = meta.getOnFocus();
		if(onFocus != null) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnFocus, onFocus.getContent());
		} 
	}

	@Override
	public void fromJSONImpl(MetaNumberInfoEditorProperties meta, JSONObject json) throws Throwable {
		meta.setEditorFormat(json.optString(JSONConstants.NUMBERINFOEDITOR_FORMAT));
		meta.setImeOptions(json.optInt(JSONConstants.NUMBEREDITOR_IMEOPTIONS));
		Object o = json.opt(JSONConstants.NUMBERINFOEDITOR_DISABLEKEYBOARD);
		if(o != null) {
			meta.setDisableKeyboard(Boolean.parseBoolean(o.toString()));
		}
		String s = json.optString(JSONConstants.Event_OnFocus);
		if (s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnFocus);
			script.setContent(s);
			meta.setOnFocus(script);
		}
	}

	@Override
	public MetaNumberInfoEditorProperties newInstance() {
		return new MetaNumberInfoEditorProperties();
	}

}
