package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;

public class MetaButtonPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaButtonProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaButtonProperties meta, DefaultSerializeContext hook,
			String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BUTTON_ICON,  meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.BUTTON_ICONLOCATION, meta.getIconLocation());
		JSONHelper.writeToJSON(json, JSONConstants.BUTTON_ONLYICON,  meta.isOnlyIcon());
		JSONHelper.writeToJSON(json, JSONConstants.BUTTON_NEEDAUTHENTICATE,  meta.isNeedAuthenticate());
		JSONHelper.writeToJSON(json, JSONConstants.BUTTON_CLICKANIM, meta.getClickAnim());
		JSONHelper.writeToJSON(json, JSONConstants.BUTTON_UPLOADFILE, meta.isUploadFile());
		JSONHelper.writeToJSON(json, JSONConstants.BUTTON_UPLOADTYPE, meta.getUploadType());
		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent().trim());
		}
		JSONHelper.writeToJSON(json, JSONConstants.BUTTON_TYPE, meta.getType());
	}

	@Override
	public void fromJSONImpl(MetaButtonProperties meta, JSONObject json) throws Throwable {
		meta.setIcon(json.optString(JSONConstants.BUTTON_ICON));
		meta.setIconLocation(json.optInt(JSONConstants.BUTTON_ICONLOCATION));
		meta.setOnlyIcon(json.optBoolean(JSONConstants.BUTTON_ONLYICON));
		meta.setNeedAuthenticate(json.optBoolean(JSONConstants.BUTTON_NEEDAUTHENTICATE));
		meta.setClickAnim(json.optString(JSONConstants.BUTTON_CLICKANIM));
		meta.setUploadFile(json.optBoolean(JSONConstants.BUTTON_UPLOADFILE));
		meta.setUploadType(json.optString(JSONConstants.BUTTON_UPLOADTYPE));
		String s = json.optString(JSONConstants.Event_OnClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnClick);
			script.setContent(s);
			meta.setOnClick(script);
		}
		meta.setType(json.optInt(JSONConstants.BUTTON_TYPE));
	}

	@Override
	public MetaButtonProperties newInstance() {
		return new MetaButtonProperties();
	}
}

