package com.bokesoft.yes.meta.json.com.moduleEditor;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.moduleeditor.MetaModuleItem;

public class MetaModuleItemJSONHandler extends AbstractJSONHandler<MetaModuleItem, DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaModuleItem meta, DefaultSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.MODULEEDITOR_ITEM_IMAGE, meta.getImage());
		JSONHelper.writeToJSON(json, JSONConstants.MODULEEDITOR_ITEM_GROUPVALUE, meta.getGroupValue());
		JSONHelper.writeToJSON(json, JSONConstants.MODULEEDITOR_ITEM_GROUPCAPTION, meta.getGroupCaption());
	}

	@Override
	public void fromJSONImpl(MetaModuleItem meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setImage(json.optString(JSONConstants.MODULEEDITOR_ITEM_IMAGE));
		meta.setGroupValue(json.optString(JSONConstants.MODULEEDITOR_ITEM_GROUPVALUE));
		meta.setGroupCaption(json.optString(JSONConstants.MODULEEDITOR_ITEM_GROUPCAPTION));
	}

	@Override
	public MetaModuleItem newInstance() {
		return new MetaModuleItem();
	}

}
