package com.bokesoft.yes.meta.json.com.listView;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaMoreItem;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRotatorList;

public class MetaRotatorListJSONHandler extends MetaListViewJSONHandler<MetaRotatorList> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaRotatorList meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.ROTATORLIST_ROWCOUNT, meta.getRowCount());
		JSONHelper.writeToJSON(json, JSONConstants.ROTATORLIST_COLUMNCOUNT, meta.getColumnCount());
		JSONHelper.writeToJSON(json, JSONConstants.ROTATORLIST_ROWGAP, meta.getRowGap());
		JSONHelper.writeToJSON(json, JSONConstants.ROTATORLIST_CELLGAP, meta.getCellGap());
		JSONHelper.writeToJSON(json, JSONConstants.ROTATER_INDICATOR, meta.isIndicator());
		JSONHelper.writeToJSON(json, JSONConstants.ROTATER_INDICATORLOCATION, meta.getIndicatorLocation());
		JSONHelper.writeToJSON(json, JSONConstants.ROTATER_PAGINATION, meta.isPagination());
		
		MetaMoreItem moreItem = meta.getMoreItem();
		if( moreItem != null ) {
			JSONObject o = UIJSONHandlerUtil.build(moreItem,hook);
			JSONHelper.writeToJSON(json, JSONConstants.ROTATORLIST_MOREITEM, o);
		}
	}
	
	@Override
	public void fromJSONImpl(MetaRotatorList meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setRowCount(json.optInt(JSONConstants.ROTATORLIST_ROWCOUNT));
		meta.setColumnCount(json.optInt(JSONConstants.ROTATORLIST_COLUMNCOUNT));
		meta.setRowGap(json.optInt(JSONConstants.ROTATORLIST_ROWGAP));
		meta.setCellGap(json.optInt(JSONConstants.ROTATORLIST_CELLGAP));
		meta.setIndicator(json.optBoolean(JSONConstants.ROTATER_INDICATOR));
		meta.setIndicatorLocation(json.optInt(JSONConstants.ROTATER_INDICATORLOCATION));
		meta.setPagination(json.optBoolean(JSONConstants.ROTATER_PAGINATION));
		
		JSONObject o = json.optJSONObject(JSONConstants.ROTATORLIST_MOREITEM);
		if( o != null ) {
			MetaMoreItem moreItem = UIJSONHandlerUtil.unbuild(MetaMoreItem.class, o);
			meta.setMoreItem(moreItem);
		}
	}
	
	@Override
	public MetaRotatorList newInstance() {
		return new MetaRotatorList();
	}
}
