package com.bokesoft.yes.meta.json.com.listView;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumnCollection;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewItem;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewItemCollection;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewRow;

public class MetaListViewJSONHandler<T extends MetaListView> extends BaseComponentJSONHandler<T> {
	
	@Override
	public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setSelectFieldIndex(json.optInt(JSONConstants.LISTVIEW_SELECTFIELDINDEX));
		meta.setTableKey(json.optString(JSONConstants.LISTVIEW_TABLEKEY));
		meta.setDefaultSelectRow(json.optInt(JSONConstants.LISTVIEW_DEFAULTSELECTROW));
		meta.setPageLoadType(json.optInt(JSONConstants.LISTVIEW_PAGELOADTYPE));
		meta.setPageRowCount(json.optInt(JSONConstants.LISTVIEW_PAGEROWCOUNT));
		meta.setPromptText(json.optString(JSONConstants.COMPONENT_PROMPTTEXT));
		meta.setPromptImage(json.optString(JSONConstants.IMAGE_PROMPTIMAGE));
		meta.setPromptRowCount(json.optInt(JSONConstants.LISTVIEW_PROMPTROWCOUNT));
		meta.setItemAnim(json.optString(JSONConstants.COMMON_ITEMANIM));
		meta.setLayoutAnim(json.optString(JSONConstants.COMMON_LAYOUTANIM));
		meta.setRowHeight(json.optInt(JSONConstants.LISTVIEW_ROWHEIGHT));
		meta.setShowHead(json.optBoolean(JSONConstants.TABPANEL_SHOWHEAD));
		meta.setOrientation(json.optInt(JSONConstants.TILEDLIST_ORIENTATION));
		meta.setScrollXY(json.optBoolean(JSONConstants.LISTVIEW_SCROLLXY));
		meta.setEditRowFormKey(json.optString(JSONConstants.LISTVIEW_EDITROWFORMKEY));
		meta.setSortType(json.optInt(JSONConstants.LISTVIEW_SORTTYPE));
		
		if(!json.isNull(JSONConstants.LISTVIEW_SHOWTOTALROWCOUNT)) {
			meta.setShowTotalRowCount(json.optBoolean(JSONConstants.LISTVIEW_SHOWTOTALROWCOUNT));
		}
		
		JSONArray array = json.optJSONArray(JSONConstants.LISTVIEW_COLUMNINFO);
		if( array != null ) {
			MetaListViewColumnCollection columnCollection = new MetaListViewColumnCollection();
			List<MetaListViewColumn> list = UIJSONHandlerUtil.unbuild(MetaListViewColumn.class, array);
			columnCollection.addAll(list);
			meta.setColumnCollection(columnCollection);
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.LISTVIEW_ROWINFO);
		if( o != null ) {
			MetaListViewRow listViewRow = UIJSONHandlerUtil.unbuild(MetaListViewRow.class, o);
			meta.setRow(listViewRow);
		}		
		
		String s = json.optString(JSONConstants.Event_RowClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_RowClick);
			script.setContent(s);
			meta.setRowClick(script);
		}
		s = json.optString(JSONConstants.Event_FocusRowChanged);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_FocusRowChanged);
			script.setContent(s);
			meta.setFocusRowChanged(script);
		}
		s = json.optString(JSONConstants.Event_RowDblClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_RowDblClick);
			script.setContent(s);
			meta.setRowDblClick(script);
		}
		
		array = json.optJSONArray(JSONConstants.LISTVIEW_ITEMS);
		if(array != null){
			MetaListViewItemCollection collection = new MetaListViewItemCollection();
			List<MetaListViewItem> list = UIJSONHandlerUtil.unbuild(MetaListViewItem.class, array);
			collection.addAll(list);
			meta.setItemCollection(collection);
			
			s = json.optString(JSONConstants.COMBOBOX_FORMULA);
			if (s != null && !s.isEmpty()) {
				MetaBaseScript script = new MetaBaseScript(MetaConstants.COMBOBOX_FORMULAITEMS);
				script.setContent(s);
				collection.setFormulaItems(script);
			}
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, T meta, DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_SELECTFIELDINDEX, meta.getSelectFieldIndex());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_COLUMN_HASSELECTFIELD, meta.hasSelectField());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_DEFAULTSELECTROW, meta.getDefaultSelectRow());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_PAGELOADTYPE, meta.getPageLoadType());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_PAGEROWCOUNT, meta.getPageRowCount());

		String promptText = hook.getString(GroupKeyTable.STR_PROMPT, "", meta.getKey(), meta.getPromptText());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, promptText);
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_PROMPTIMAGE, meta.getPromptImage());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_PROMPTROWCOUNT, meta.getPromptRowCount());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMANIM, meta.getItemAnim());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_LAYOUTANIM, meta.getLayoutAnim());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROWHEIGHT, meta.getRowHeight());
		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_SHOWHEAD, meta.isShowHead());
		JSONHelper.writeToJSON(json, JSONConstants.TILEDLIST_ORIENTATION, meta.getOrientation());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_SCROLLXY, meta.isScrollXY());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_SHOWTOTALROWCOUNT, meta.isShowTotalRowCount());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_EDITROWFORMKEY, meta.getEditRowFormKey());
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_SORTTYPE, meta.getSortType());
		
		MetaListViewColumnCollection columnCollection = meta.getColumnCollection();
		if( columnCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, columnCollection);
			JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_COLUMNINFO, array);
		}
		
		MetaListViewRow listViewRow = meta.getRow();
		if( listViewRow != null ) {
			JSONObject rowObject = UIJSONHandlerUtil.build(listViewRow,hook);
			JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ROWINFO, rowObject);
		}
		
		MetaBaseScript rowClick = meta.getRowClick();
		if( rowClick != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowClick, rowClick.getContent().trim());
		}
		
		MetaBaseScript dbClick = meta.getRowDblClick();
		if( dbClick != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowDblClick, dbClick.getContent().trim());
		}
		
		MetaBaseScript rowChange = meta.getFocusRowChanged();
		if(rowChange != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_FocusRowChanged, rowChange.getContent().trim());
		}
	
		JSONHelper.writeToJSON(json, JSONConstants.PRIMARYKEYS, meta.getPrimaryKeys());
		
		MetaListViewItemCollection itemCollection = meta.getItemCollection();
		if(itemCollection != null){
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, itemCollection);
			JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_ITEMS, array);
			
			MetaBaseScript formulaItems = itemCollection.getFormulaItems();
			if( formulaItems != null ) {
				JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_FORMULA, formulaItems.getContent().trim());
			}
		}
		

	}

	@SuppressWarnings("unchecked")
	@Override
	public T newInstance() {
		return (T)new MetaListView();
	}

}
