package com.bokesoft.yes.meta.json.com.grid;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.common.def.ColumnType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.form.component.grid.MetaColumnExpand;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;

public class MetaGridColumnJSONHandler extends AbstractJSONHandler<MetaGridColumn,DefaultSerializeContext> {
	
	@Override
	public void fromJSONImpl(MetaGridColumn meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setFormulaCaption(json.optString(JSONConstants.GRID_FORMULACAPTION));
		
		String s = json.optString(JSONConstants.COMMON_WIDTH);
		if( s != null && !s.isEmpty() ) {
			meta.setWidth(DefSize.parse(s));
		}
		meta.setMetaCellImage(json.optString(JSONConstants.Grid_MetaCellImage));
		meta.setSortable(json.optBoolean(JSONConstants.GRID_SORTABLE));
		meta.setEnable(json.optString(JSONConstants.COMMON_ENABLE));
		meta.setEnableDependency(json.optString(JSONConstants.COMMON_ENABLEDEPENDENCY));
		meta.setVisible(json.optString(JSONConstants.COMMON_VISIBLE));
		meta.setVisibleDependency(json.optString(JSONConstants.COMMON_VISIBLEDEPENDENCY));
		meta.setImage(json.optString(JSONConstants.GRID_IMAGE));
		meta.setColumnType(json.optInt(JSONConstants.COMMON_TYPE));
		meta.setFrozen(json.optBoolean(JSONConstants.GRID_FROZEN));

		JSONObject o = json.optJSONObject(JSONConstants.GRID_COLUMNEXPAND);
		if( o != null ) {
			MetaColumnExpand columnExpand = UIJSONHandlerUtil.unbuild(MetaColumnExpand.class, o);
			meta.setMetaColumnExpand(columnExpand);
		}
		
		JSONArray array = json.optJSONArray(JSONConstants.GRID_COLUMNS);
		if( array != null ) {
			MetaGridColumnCollection collection = new MetaGridColumnCollection();
			List<MetaGridColumn> columns = UIJSONHandlerUtil.unbuild(MetaGridColumn.class, array);
			collection.addAll(0, columns);
			meta.setColumnCollection(collection);
		}
	}	
	
	@Override
	public void toJSONImpl(JSONObject json, MetaGridColumn meta, DefaultSerializeContext hook)
			throws Throwable {
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		// 列扩展配置在加载metaForm时会更改key的属性，传递组件原始key
		json.put("metaGridColumnKey", meta.getMetaGridColumnKey());
		
		String caption = hook.getString(GroupKeyTable.STR_GRIDCOLUMN, "", meta.getOldKey(), meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, caption);
		JSONHelper.writeToJSON(json, JSONConstants.GRID_FORMULACAPTION, meta.getFormulaCaption());
		
		DefSize width = meta.getWidth();
		if( width != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, width.toString(), "");			
		}
		JSONHelper.writeToJSON(json, JSONConstants.Grid_MetaCellImage, meta.getMetaCellImage());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_IMAGE, meta.getImage());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_SORTABLE, meta.getSortable());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ENABLE, meta.getEnable());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ENABLEDEPENDENCY, meta.getEnableDependency());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VISIBLE, meta.getVisible());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VISIBLEDEPENDENCY, meta.getVisibleDependency());
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getColumnType());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_COLUMNTYPE, ColumnType.toString(meta.getColumnType()));
		JSONHelper.writeToJSON(json, JSONConstants.GRID_FROZEN, meta.isFrozen());
		
		MetaColumnExpand columnExpand = meta.getColumnExpand();
		if (columnExpand != null) {
			JSONObject o = UIJSONHandlerUtil.build(columnExpand,hook);
			JSONHelper.writeToJSON(json, JSONConstants.GRID_COLUMNEXPAND, o);
		}
		
		JSONArray columnArray = new JSONArray();
		MetaGridColumnCollection collection = meta.getColumnCollection();
		if (collection != null) {
			for( MetaGridColumn metaColumn : collection ) {
				JSONObject o = UIJSONHandlerUtil.build(metaColumn,hook);
				o.put("parentKey", meta.getKey());
				columnArray.put(o);
			}
			JSONHelper.writeToJSON(json, JSONConstants.GRID_COLUMNS, columnArray);
		}
		JSONHelper.writeToJSON(json, "isNewExtField", meta.isNewExtField()); // 是否是马甲新增的字段
	}

	@Override
	public MetaGridColumn newInstance() {
		return new MetaGridColumn();
	}

}
