package com.bokesoft.yes.meta.json.com.editview;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumnCollection;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewItem;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewItemCollection;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewRow;

public class MetaEditViewJSONHandler<T extends MetaEditView> extends BaseComponentJSONHandler<T> {

	@Override
	public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);

		meta.setSelectFieldIndex(json.optInt(JSONConstants.EDITVIEW_SELECTFIELDINDEX));
		meta.setTableKey(json.optString(JSONConstants.EDITVIEW_TABLEKEY));
		meta.setDefaultSelectRow(json.optInt(JSONConstants.EDITVIEW_DEFAULTSELECTROW));
		meta.setPageLoadType(json.optInt(JSONConstants.EDITVIEW_PAGELOADTYPE));
		meta.setPageRowCount(json.optInt(JSONConstants.EDITVIEW_PAGEROWCOUNT));
		meta.setPromptText(json.optString(JSONConstants.COMPONENT_PROMPTTEXT));
		meta.setPromptImage(json.optString(JSONConstants.IMAGE_PROMPTIMAGE));
		meta.setPromptRowCount(json.optInt(JSONConstants.EDITVIEW_PROMPTROWCOUNT));
		meta.setItemAnim(json.optString(JSONConstants.COMMON_ITEMANIM));
		meta.setLayoutAnim(json.optString(JSONConstants.COMMON_LAYOUTANIM));
		meta.setRowHeight(json.optInt(JSONConstants.EDITVIEW_ROWHEIGHT));
		meta.setShowHead(json.optBoolean(JSONConstants.TABPANEL_SHOWHEAD));
		meta.setOrientation(json.optInt(JSONConstants.TILEDLIST_ORIENTATION));
		meta.setScrollXY(json.optBoolean(JSONConstants.EDITVIEW_SCROLLXY));
		meta.setEditRowFormKey(json.optString(JSONConstants.EDITVIEW_EDITROWFORMKEY));

		if(!json.isNull(JSONConstants.EDITVIEW_SHOWTOTALROWCOUNT)) {
			meta.setShowTotalRowCount(json.optBoolean(JSONConstants.EDITVIEW_SHOWTOTALROWCOUNT));
		}

		JSONArray array = json.optJSONArray(JSONConstants.EDITVIEW_COLUMNINFO);
		if( array != null ) {
			MetaEditViewColumnCollection columnCollection = new MetaEditViewColumnCollection();
			List<MetaEditViewColumn> list = UIJSONHandlerUtil.unbuild(MetaEditViewColumn.class, array);
			columnCollection.addAll(list);
			meta.setColumnCollection(columnCollection);
		}

		JSONObject o = json.optJSONObject(JSONConstants.EDITVIEW_ROWINFO);
		if( o != null ) {
			MetaEditViewRow EditViewRow = UIJSONHandlerUtil.unbuild(MetaEditViewRow.class, o);
			meta.setRow(EditViewRow);
		}

		String s = json.optString(JSONConstants.Event_RowClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_RowClick);
			script.setContent(s);
			meta.setRowClick(script);
		}
		s = json.optString(JSONConstants.Event_FocusRowChanged);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_FocusRowChanged);
			script.setContent(s);
			meta.setFocusRowChanged(script);
		}
		s = json.optString(JSONConstants.Event_RowDblClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_RowDblClick);
			script.setContent(s);
			meta.setRowDblClick(script);
		}

		array = json.optJSONArray(JSONConstants.EDITVIEW_ITEMS);
		if(array != null){
			MetaEditViewItemCollection collection = new MetaEditViewItemCollection();
			List<MetaEditViewItem> list = UIJSONHandlerUtil.unbuild(MetaEditViewItem.class, array);
			collection.addAll(list);
			meta.setItemCollection(collection);

			s = json.optString(JSONConstants.COMBOBOX_FORMULA);
			if (s != null && !s.isEmpty()) {
				MetaBaseScript script = new MetaBaseScript(MetaConstants.COMBOBOX_FORMULAITEMS);
				script.setContent(s);
				collection.setFormulaItems(script);
			}
		}
		meta.setHasSubDetail(json.optBoolean(JSONConstants.GRID_HASSUBDETAIL));
		meta.setLinkType(json.optInt(JSONConstants.GRID_LINKTYPE));
		meta.setTarget(json.optString(JSONConstants.GRID_TARGET));
		meta.setSource(json.optString(JSONConstants.GRID_SOURCE));
	}

	@Override
	public void toJSONImpl(JSONObject json, T meta, DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);

		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_SELECTFIELDINDEX, meta.getSelectFieldIndex());
		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_COLUMN_HASSELECTFIELD, meta.hasSelectField());
		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_DEFAULTSELECTROW, meta.getDefaultSelectRow());
		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_PAGELOADTYPE, meta.getPageLoadType());
		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_PAGEROWCOUNT, meta.getPageRowCount());

		String promptText = hook.getString(GroupKeyTable.STR_PROMPT, "", meta.getKey(), meta.getPromptText());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, promptText);
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_PROMPTIMAGE, meta.getPromptImage());
		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_PROMPTROWCOUNT, meta.getPromptRowCount());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMANIM, meta.getItemAnim());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_LAYOUTANIM, meta.getLayoutAnim());
		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_ROWHEIGHT, meta.getRowHeight());
		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_SHOWHEAD, meta.isShowHead());
		JSONHelper.writeToJSON(json, JSONConstants.TILEDLIST_ORIENTATION, meta.getOrientation());
		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_SCROLLXY, meta.isScrollXY());
		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_SHOWTOTALROWCOUNT, meta.isShowTotalRowCount());
		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_EDITROWFORMKEY, meta.getEditRowFormKey());

		MetaEditViewColumnCollection columnCollection = meta.getColumnCollection();
		if( columnCollection != null ) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, columnCollection);
			JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_COLUMNINFO, array);
		}

		MetaEditViewRow EditViewRow = meta.getRow();
		if( EditViewRow != null ) {
			JSONObject rowObject = UIJSONHandlerUtil.build(EditViewRow,hook);
			JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_ROWINFO, rowObject);
		}

		MetaBaseScript rowClick = meta.getRowClick();
		if( rowClick != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowClick, rowClick.getContent().trim());
		}

		MetaBaseScript dbClick = meta.getRowDblClick();
		if( dbClick != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowDblClick, dbClick.getContent().trim());
		}

		MetaBaseScript rowChange = meta.getFocusRowChanged();
		if(rowChange != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_FocusRowChanged, rowChange.getContent().trim());
		}

		JSONHelper.writeToJSON(json, JSONConstants.PRIMARYKEYS, meta.getPrimaryKeys());

		MetaEditViewItemCollection itemCollection = meta.getItemCollection();
		if(itemCollection != null){
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, itemCollection);
			JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_ITEMS, array);

			MetaBaseScript formulaItems = itemCollection.getFormulaItems();
			if( formulaItems != null ) {
				JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_FORMULA, formulaItems.getContent().trim());
			}
		}

		JSONHelper.writeToJSON(json, JSONConstants.GRID_LINKTYPE, meta.getLinkType());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_TARGET, meta.getTarget());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_SOURCE, meta.getSource());

		JSONHelper.writeToJSON(json, JSONConstants.GRID_TARGETFIELDS, meta.getTargetFields());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_SOURCEFIELDS, meta.getSourceFields());
	}

	@SuppressWarnings("unchecked")
	@Override
	public T newInstance() {
		return (T) new MetaEditView();
	}

}
