package com.bokesoft.yes.meta.json.com.editview;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.PropertiesJSONHandlerMap;
import com.bokesoft.yes.meta.json.com.properties.BasePropertiesJSONHandler;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;

public class MetaEditViewColumnJSONHandler extends BaseComponentJSONHandler<MetaEditViewColumn>{
	
	@Override
	public void fromJSONImpl(MetaEditViewColumn meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
//		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
//		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setColumnKey(json.optString(JSONConstants.EDITVIEW_COLUMN_DATAKEY));
		meta.setDefaultValue(json.optString(JSONConstants.COMMON_DEFAULTVALUE));
		meta.setDefaultFormulaValue(json.optString(JSONConstants.COMMON_DEFAULTFORMULAVALUE));
		meta.setColumnType(json.optInt(JSONConstants.EDITVIEW_COLUMN_TYPE));
		meta.setSelect(json.optBoolean(JSONConstants.EDITVIEW_COLUMN_IS_SELECT));
		meta.setSingleSelect(json.optBoolean(JSONConstants.EDITVIEW_COLUMN_SINGLESELECT));
		meta.setWrapText(json.optBoolean(JSONConstants.EDITVIEW_COLUMN_WRAPTEXT));
		meta.setSortable(json.optBoolean(JSONConstants.EDITVIEW_COLUMN_SORTABLE));
//		meta.setEnable(json.optString(JSONConstants.COMMON_ENABLE));
//		meta.setVisible(json.optString(JSONConstants.COMMON_VISIBLE));
//		JSONObject o = json.optJSONObject(JSONConstants.COMMON_FORMAT);
//		if( o != null ) {
//			MetaFormat format = JSONHandlerUtil.unbuild(MetaFormat.class, o);
//			meta.setFormat(format);
//		}
		
		JSONObject o = json.optJSONObject(JSONConstants.EDITVIEW_COLUMN_PROPERTIES);
		BasePropertiesJSONHandler<AbstractMetaObject> propertesbuilder = PropertiesJSONHandlerMap.getBuilder(meta.getColumnType());
		if( o != null && propertesbuilder != null ) {
			AbstractMetaObject properties = propertesbuilder.fromJSON(o);
			meta.setProperties(properties);
		}
		
//		o = json.optJSONObject(JSONConstants.COMPONENT_DATABINDING);
//		if( o != null ) {
//			MetaDataBinding dataBinding = JSONHandlerUtil.unbuild(MetaDataBinding.class, o);
//			meta.setDataBinding(dataBinding);
//		}
	}

	@Override
	public void toJSONImpl(JSONObject json, MetaEditViewColumn meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		String caption = hook.getString(GroupKeyTable.STR_EDITVIEWCOLUMN, "", meta.getKey(), meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, caption);
		
		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_COLUMN_TYPE, meta.getColumnType());
		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_COLUMN_IS_SELECT, meta.isSelect());
		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_COLUMN_SINGLESELECT, meta.singleSelect());
		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_COLUMN_WRAPTEXT, meta.isWrapText());
		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_COLUMN_DATAKEY, meta.getDataColumnKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DEFAULTVALUE, meta.getDefaultValue());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DEFAULTFORMULAVALUE, meta.getDefaultFormulaValue());
		JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_COLUMN_SORTABLE, meta.isSortable());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TAGNAME, ControlType.toString(meta.getColumnType()));
//		MetaFormat format = meta.getFormat();
//		if( format != null ) {
//			JSONObject o = JSONHandlerUtil.build(ve, hook, metaForm, format);
//			JSONHelper.writeToJSON(json,JSONConstants.COMMON_FORMAT, o);
//		}
		
		AbstractMetaObject properties = meta.getProperties();
		BasePropertiesJSONHandler<AbstractMetaObject> propertiesJSONHandler = PropertiesJSONHandlerMap.getBuilder(meta.getColumnType());
        if( properties != null && propertiesJSONHandler != null ) {
        	JSONObject o = propertiesJSONHandler.toJSON(properties, hook, meta.getKey());
			JSONHelper.writeToJSON(o, JSONConstants.COMMON_KEY, meta.getKey());
        	JSONHelper.writeToJSON(json, JSONConstants.EDITVIEW_COLUMN_PROPERTIES, o);
        }
        
//        MetaDataBinding dataBinding = meta.getDataBinding();
//        if( dataBinding != null ) {
//        	JSONObject o = JSONHandlerUtil.build(ve, hook, metaForm, dataBinding);
//        	JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_DATABINDING, o);
//        }
	}

	@Override
	public MetaEditViewColumn newInstance() {
		return new MetaEditViewColumn();
	}

}
