package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.shrinkview.MetaToolBarExpand;

public class MetaToolBarExpandJSONHandler extends AbstractJSONHandler<MetaToolBarExpand,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaToolBarExpand meta, DefaultSerializeContext hook)
			throws Throwable {
		MetaComponent root = meta.getRoot();
		if( root != null ) {
			JSONObject o = UIJSONHandlerUtil.build(root,hook);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_ROOT, o);
		}
	}

	@Override
	public void fromJSONImpl(MetaToolBarExpand meta, JSONObject json) throws Throwable {
		JSONObject o = json.optJSONObject(JSONConstants.COMMON_ROOT);
		if( o != null ) {
			MetaComponent root = (MetaComponent) UIJSONHandlerUtil.unbuild(o);
			meta.setRoot(root);
		}
	}

	@Override
	public MetaToolBarExpand newInstance() {
		return new MetaToolBarExpand();
	}

}
