package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.navigationlist.MetaNavigationListRow;

public class MetaNavigationListRowJSONHandler extends AbstractJSONHandler<MetaNavigationListRow,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaNavigationListRow meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BACKCOLOR, meta.getBackColor());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORECOLOR, meta.getForeColor());
		JSONHelper.writeToJSON(json, JSONConstants.FONT_SIZE, meta.getFontSize());
		JSONHelper.writeToJSON(json, JSONConstants.FORMAT_HIGHLIGHTBACKCOLOR, meta.getHighlightColor());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_PANDDING, meta.getPadding());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_LEFTPANDDING, meta.getLeftPadding());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_RIGHTPADDING, meta.getRightPadding());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TOPPADDING, meta.getTopPadding());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BOTTOMPADDING, meta.getBottomPadding());
	}

	@Override
	public void fromJSONImpl(MetaNavigationListRow meta, JSONObject json) throws Throwable {
		meta.setBackColor(json.optString(JSONConstants.COMMON_BACKCOLOR));
		meta.setForeColor(json.optString(JSONConstants.COMMON_FORECOLOR));
		meta.setFontSize(json.optInt(JSONConstants.FONT_SIZE));
		meta.setHighlightColor(json.optString(JSONConstants.FORMAT_HIGHLIGHTBACKCOLOR));
		meta.setPadding(json.optString(JSONConstants.COMMON_PANDDING));
		meta.setLeftPadding(json.optString(JSONConstants.COMMON_LEFTPANDDING));
		meta.setRightPadding(json.optString(JSONConstants.COMMON_RIGHTPADDING));
		meta.setTopPadding(json.optString(JSONConstants.COMMON_TOPPADDING));
		meta.setBottomPadding(json.optString(JSONConstants.COMMON_BOTTOMPADDING));
	}
	
	@Override
	public MetaNavigationListRow newInstance() {
		return new MetaNavigationListRow();
	}

}
