package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.form.component.control.dictview.MetaDictViewColumn;

public class MetaDictViewColumnJSONHandler extends AbstractJSONHandler<MetaDictViewColumn,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaDictViewColumn meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		String caption = hook.getString(GroupKeyTable.STR_DICTVIEWCOLUMN, "", meta.getKey(), meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, caption);
		
		DefSize width = meta.getWidth();
		if (width != null) {
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, width.toString(), "");
		}
	}

	@Override
	public void fromJSONImpl(MetaDictViewColumn meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		
		String s = json.optString(JSONConstants.COMMON_WIDTH);
		if( s != null && !s.isEmpty() ) {
			meta.setWidth(DefSize.parse(s));
		}
	}

	@Override
	public MetaDictViewColumn newInstance() {
		return new MetaDictViewColumn();
	}

}
