package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.node.MetaGateWay;

public class MetaGateWayJSONHandler extends MetaNodeJSONHandler<MetaGateWay> {

	@Override
	public void fromJSONImpl(MetaGateWay meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setCondition(json.optString(JSONConstants.COMMON_CONDITION));
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaGateWay meta, BPMSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CONDITION, meta.getCondition());
	}
	
	@Override
	public MetaGateWay newInstance() {
		return new MetaGateWay();
	}
}
