package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataItem;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaDataItemJSONHandler extends AbstractJSONHandler<MetaDataItem, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaDataItem meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setFromDefault(json.optBoolean(JSONConstants.DATA_ITEM_DEFAULT));
		meta.setDataType(json.optInt(JSONConstants.COMMON_DATATYPE));
		meta.setCache(json.optBoolean(JSONConstants.COMBOBOX_NEEDCACHE));
		
		String s = json.optString(JSONConstants.BPM_CONTENT);
		if(s.length() > 0){
			MetaBaseScript content = new MetaBaseScript(BPMConstants.DATA_ITEM_CONTENT);
			content.setContent(s);
			meta.setContent(content);
		}
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaDataItem meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.DATA_ITEM_DEFAULT, meta.isFromDefault());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DATATYPE, meta.getDataType());
		JSONHelper.writeToJSON(json, JSONConstants.COMBOBOX_NEEDCACHE, meta.isCache());
		
		MetaBaseScript content = meta.getContent();
		if(content != null){
			JSONHelper.writeToJSON(json, JSONConstants.BPM_CONTENT, content.getContent().trim());
		}
	}
	
	@Override
	public MetaDataItem newInstance() {
		return new MetaDataItem();
	}
}
