package com.bokesoft.yes.meta.json;

import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.solution.MetaProject;
import com.bokesoft.yigo.meta.strings.MetaStringTable;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.tools.ve.VE;

public class DefaultSerializeContext extends AbstractSerializeContext {	
	private MetaForm metaForm = null;
						
	public DefaultSerializeContext(MetaForm metaForm,VE ve) {
		super(ve);
		this.metaForm = metaForm;
	}

	public MetaForm getMetaForm() {
		return metaForm;
	}

	public String getFormKey() {
		return metaForm.getKey();
	}

	public String getString(String group, String groupKey, String word, String org) throws Throwable{
		IMetaFactory metaFactory = ve.getMetaFactory();
		if(!metaFactory.getSolution().isEnableMultiLang()){
			return org;
		}
		
		String s = null;
		String lang = ve.getEnv().getLocale();
		
		String key = group;
		if(groupKey != null && !groupKey.isEmpty()){
			key +="-"+ groupKey;
		}

		switch (GroupKeyTable.parse(group)) {
			case GroupKeyTable.UI:
				s = metaForm.getUILangCaption(lang, key);
				if (s != null) {
					return s;
				}			
				break;
		}

		return MetaUtil.getLocalString(metaFactory, metaForm, lang, key, word, org, s);
	}

}
